# 亚马逊智能采集器 (Browser Extension)

Chrome 浏览器扩展，用于在亚马逊页面自动采集 ASIN 并上传至后端 API。

## 版本信息

- **当前版本**: 2.1.0 (站点快捷访问增强版)
- **Manifest 版本**: 3
- **支持的站点**: 全球 20 个亚马逊站点
  - 🇺🇸 美国 (US) - amazon.com
  - 🇬🇧 英国 (UK) - amazon.co.uk
  - 🇩🇪 德国 (DE) - amazon.de
  - 🇫🇷 法国 (FR) - amazon.fr
  - 🇮🇹 意大利 (IT) - amazon.it
  - 🇪🇸 西班牙 (ES) - amazon.es
  - 🇯🇵 日本 (JP) - amazon.co.jp
  - 🇨🇦 加拿大 (CA) - amazon.ca
  - 🇦🇺 澳大利亚 (AU) - amazon.com.au
  - 🇲🇽 墨西哥 (MX) - amazon.com.mx
  - 🇧🇷 巴西 (BR) - amazon.com.br
  - 🇮🇳 印度 (IN) - amazon.in
  - 🇸🇬 新加坡 (SG) - amazon.sg
  - 🇦🇪 阿联酋 (AE) - amazon.ae
  - 🇸🇦 沙特阿拉伯 (SA) - amazon.sa
  - 🇳🇱 荷兰 (NL) - amazon.nl
  - 🇵🇱 波兰 (PL) - amazon.pl
  - 🇸🇪 瑞典 (SE) - amazon.se
  - 🇮🇪 爱尔兰 (IE) - amazon.ie
  - 🇧🇪 比利时 (BE) - amazon.com.be

## 功能特性

### 🌍 站点快捷访问 (v2.1.0 新增)

- **一键打开全球站点**: 快速访问全球 20 个亚马逊站点
- **智能站点识别**: 自动高亮当前所在站点
- **实时搜索过滤**: 快速查找目标站点
- **美观的网格布局**: 国旗 + 站点代码 + 国家名称
- **🏆 Bestsellers 快捷访问**: 可选择直接打开 Bestsellers 页面（默认勾选）

### ✅ 自动 ASIN 采集

- 从亚马逊商品列表页面提取 ASIN
- 自动识别并去重
- 支持多页面批量采集

### ✅ 智能分页

- 自动检测分页按钮
- 逐页采集，实时显示进度
- 支持暂停/继续/取消

### ✅ 数据上传

- 自动上传到后端 API
- 包含完整的页面元信息（站点、分类、搜索词等）
- 实时反馈上传状态

### ✅ 用户友好

- 🎨 现代化界面设计
- 💫 流畅的动画效果
- 📊 实时进度显示
- 🔧 详细的错误提示
- ⚙️ 可配置 API 端点

## 安装指南

### 1. 加载扩展到 Chrome

1. 打开 Chrome 浏览器
2. 访问 `chrome://extensions/`
3. 启用右上角的"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择 `browser-extension-asin-scraper` 目录
6. 扩展将出现在工具栏中

### 2. 配置 API 端点

1. 点击扩展图标
2. 在"API 地址"输入框中输入后端 API 地址
   - 默认：`https://njdk.xyz:18012/api/upload-asins`
3. 点击"保存配置"按钮

## 使用方法

### 基本使用流程

1. **快速访问亚马逊站点** (v2.1.0 新功能 🌍)
   - 点击扩展图标
   - 展开"站点快捷访问"面板
   - 🏆 **可选择是否打开 Bestsellers 页面**（默认勾选）
   - 点击任意站点按钮快速打开
   - 使用搜索框快速筛选站点

2. **打开亚马逊搜索页面**
   - 例如：<https://www.amazon.com/s?k=laptop>
   - 或任何包含商品列表的页面

3. **启动扩展**
   - 点击浏览器工具栏中的扩展图标
   - 查看页面信息（站点、分类、搜索词等）
   - 当前所在站点会在"站点快捷访问"中高亮显示

4. **开始采集**
   - 点击"开始采集"按钮
   - 扩展将自动：
     - 提取当前页面的所有 ASIN
     - 自动翻页继续采集
     - 实时更新进度

5. **查看结果**
   - 采集完成后，数据自动上传到后端
   - 访问仪表板查看统计：<https://njdk.xyz:18012/dashboard/dashboard.html>

### 高级功能

**暂停采集**

- 点击"暂停"按钮暂停当前采集
- 点击"继续"恢复采集

**取消采集**

- 点击"取消"按钮停止采集
- 已采集的数据仍会上传

**重置状态**

- 点击"重置"按钮清除当前状态
- 准备开始新的采集任务

## 快速测试

### 方法 1: 使用测试脚本

**Windows (PowerShell):**

```powershell
cd browser-extension-asin-scraper
.\test-api.ps1
```

**Linux/Mac (Bash):**

```bash
cd browser-extension-asin-scraper
chmod +x test-api.sh
./test-api.sh
```

### 方法 2: 手动测试

```bash
# 测试健康检查
curl https://njdk.xyz:18012/health

# 测试 API 上传
curl -X POST https://njdk.xyz:18012/api/upload-asins \
  -H "Content-Type: application/json" \
  -d '{
    "asinList": ["B08N5WRWNW"],
    "site": "US",
    "source": "test"
  }'
```

## 故障排查

如果遇到问题，请参考 **[故障排查指南](./TROUBLESHOOTING.md)**

### 常见问题快速参考

#### ❌ ERR_BLOCKED_BY_CLIENT

- **原因**: 广告拦截器阻止了亚马逊的某些资源
- **影响**: 无影响，可以忽略
- **详情**: 参见 [TROUBLESHOOTING.md](./TROUBLESHOOTING.md#1-err_blocked_by_client-错误)

#### ❌ runtime.lastError

- **原因**: Chrome 扩展消息通道问题
- **解决**: 更新到 v2.0.2 已修复
- **详情**: 参见 [TROUBLESHOOTING.md](./TROUBLESHOOTING.md#2-unchecked-runtimelasterror-错误)

#### ❌ Failed to fetch

- **原因**: 无法连接到 API 服务器
- **检查**:
  1. 服务器是否运行
  2. HTTPS 证书是否有效
  3. 防火墙设置
- **详情**: 参见 [TROUBLESHOOTING.md](./TROUBLESHOOTING.md#3-failed-to-fetch--网络连接错误)

## 技术架构

### 扩展组件

```
browser-extension-asin-scraper/
├── manifest.json              # 扩展配置
├── src/
│   ├── background/
│   │   └── service-worker.js  # 后台服务（API 调用）
│   ├── content/
│   │   └── content-script.js  # 内容脚本（ASIN 提取）
│   ├── popup/
│   │   ├── popup.html         # 弹出窗口界面
│   │   ├── popup.js           # 弹出窗口逻辑
│   │   └── popup.css          # 样式
│   └── utils/
│       └── constants.js       # 常量配置
├── icons/                     # 扩展图标
├── test-api.sh                # Linux/Mac 测试脚本
├── test-api.ps1               # Windows 测试脚本
├── TROUBLESHOOTING.md         # 故障排查指南
└── README.md                  # 本文件
```

### 数据流程

```
Amazon 页面
    ↓ (content-script.js 提取 ASIN)
Content Script
    ↓ (chrome.runtime.sendMessage)
Background Service Worker
    ↓ (fetch API)
Backend API (https://njdk.xyz:18012)
    ↓
PostgreSQL 数据库
```

### 消息类型

| 消息类型 | 发送者 | 接收者 | 用途 |
|---------|-------|-------|------|
| `START_SCRAPING` | Popup | Content Script | 开始采集 |
| `SCRAPING_PROGRESS` | Content Script | Background | 更新进度 |
| `SCRAPING_COMPLETE` | Content Script | Background | 采集完成 |
| `SCRAPING_CANCELLED` | Content Script | Background | 采集取消 |
| `UPLOAD_COMPLETE` | Background | Popup | 上传成功 |
| `UPLOAD_ERROR` | Background | Popup | 上传失败 |
| `GET_PAGE_INFO` | Popup | Content Script | 获取页面信息 |

## 开发指南

### 本地开发

1. **修改代码**

   ```bash
   cd browser-extension-asin-scraper/src
   # 编辑文件
   ```

2. **重新加载扩展**
   - 访问 `chrome://extensions/`
   - 点击扩展卡片上的"刷新"图标

3. **调试**
   - **Background**: `chrome://extensions/` → 点击 Service Worker
   - **Content Script**: 在亚马逊页面按 F12
   - **Popup**: 右键点击扩展图标 → 检查弹出内容

### 版本发布

1. **更新版本号**

   ```json
   // manifest.json
   {
     "version": "2.0.3"
   }
   ```

2. **测试功能**

   ```bash
   ./test-api.ps1  # Windows
   ./test-api.sh   # Linux/Mac
   ```

3. **打包扩展**
   - `chrome://extensions/`
   - 点击"打包扩展程序"
   - 选择扩展目录

## API 规范

### 上传 ASIN 端点

**请求:**

```http
POST https://njdk.xyz:18012/api/upload-asins
Content-Type: application/json

{
  "asinList": ["B08N5WRWNW", "B08N5KWB9H"],
  "timestamp": "2024-01-01T00:00:00.000Z",
  "source": "amazon-asin-scraper",
  "version": "2.0.2",
  "site": "US",
  "marketplace": "ATVPDKIKX0DER",
  "url": "https://www.amazon.com/s?k=laptop",
  "category": "Electronics",
  "categoryId": "172282",
  "searchKeyword": "laptop",
  "totalResults": "50000",
  "sellerId": null,
  "sellerName": null,
  "collectionStats": {
    "totalAsins": 2,
    "collectedAt": "2024-01-01T00:00:00.000Z"
  }
}
```

**响应:**

```json
{
  "success": true,
  "message": "ASIN data uploaded successfully",
  "count": 2,
  "uploadedAt": "2024-01-01T00:00:00.000Z",
  "metadata": {
    "site": "US",
    "category": "Electronics",
    "searchKeyword": "laptop",
    "totalResults": "50000"
  }
}
```

## 安全性

### 权限说明

- **activeTab**: 访问当前活动标签页的内容
- **storage**: 保存配置和状态
- **scripting**: 注入内容脚本到亚马逊页面

### 数据隐私

- ✅ 仅在亚马逊页面运行
- ✅ 仅采集 ASIN 和公开的页面信息
- ✅ 不收集个人信息或浏览历史
- ✅ 所有数据通过 HTTPS 加密传输

## 性能优化

- **去重**: 自动去除重复的 ASIN
- **批量上传**: 采集完成后一次性上传所有数据
- **异步处理**: 不阻塞页面渲染
- **智能分页**: 自动检测并等待页面加载完成

## 兼容性

- ✅ Chrome 88+
- ✅ Edge 88+
- ✅ Brave (基于 Chromium)
- ⚠️ Firefox: 需要修改 manifest.json（Manifest V2）

## 更新日志

### v2.1.0 (2025-10-21) - 站点快捷访问增强版 🎉

#### ✨ 新增功能

- 🌍 **站点快捷访问面板**
  - 一键快速打开全球 20 个亚马逊站点
  - 网格化按钮布局，包含国旗、站点代码和国家名称
  - 智能高亮当前所在站点
  - 支持站点搜索/过滤功能

#### 🎨 UI/UX 优化

- 💫 整体界面重构，更现代化的设计
- 🎯 折叠区域添加展开/收起动画效果
- 📱 优化卡片和按钮的视觉层次
- 💡 API配置区域默认收起，界面更简洁
- ✨ 添加平滑的过渡动画和悬停效果
- 🎨 当前站点按钮添加脉冲动画高亮
- 🌈 优化渐变背景和阴影效果

#### 🔧 技术改进

- 📦 添加国旗 emoji 到站点配置
- 🎨 优化 CSS 结构，添加更多动画
- 💻 改进 JavaScript 代码组织
- 🔍 实现实时站点搜索过滤功能

### v2.0.3 (2024年更新)

- ✅ 支持全球 20 个亚马逊站点
- ✅ 优化站点识别逻辑

### v2.0.2 (2024-01-21)

- ✅ 修复 `runtime.lastError` 异步消息错误
- ✅ 改进网络错误处理和提示信息
- ✅ 增强 HTTPS 连接错误诊断
- ✅ 添加详细的故障排查指南
- ✅ 新增 API 测试脚本

### v2.0.1

- ✅ 基础 ASIN 采集功能
- ✅ 自动分页支持
- ✅ 多站点支持（US, DE, UK, JP）
- ✅ 实时进度显示

## 贡献指南

欢迎提交 Issue 和 Pull Request！

### 报告 Bug

请提供以下信息：

1. 扩展版本号
2. 浏览器版本
3. 错误截图
4. 控制台日志
5. 复现步骤

### 功能建议

请描述：

1. 功能需求
2. 使用场景
3. 预期行为

## 许可证

MIT License

## 相关链接

- **后端 API 服务**: [asin-api-service](../asin-api-service/)
- **仪表板**: <https://njdk.xyz:18012/dashboard/dashboard.html>
- **健康检查**: <https://njdk.xyz:18012/health>
- **故障排查**: [TROUBLESHOOTING.md](./TROUBLESHOOTING.md)

## 支持

如有问题，请参考：

1. [故障排查指南](./TROUBLESHOOTING.md)
2. 运行测试脚本：`test-api.ps1` 或 `test-api.sh`
3. 查看浏览器控制台日志
4. 提交 GitHub Issue

---

**Happy Scraping! 🚀**
