/**
 * 常量配置文件
 */

// API 配置
export const API_CONFIG = {
  // 后端API地址（可配置）
  UPLOAD_ENDPOINT: 'https://njdk.xyz:18012/api/upload-asins',
  // UPLOAD_ENDPOINT: 'http://localhost:4500/api/upload-asins',
  TIMEOUT: 30000 // 30秒超时
}

// 消息类型
export const MESSAGE_TYPES = {
  START_SCRAPING: 'START_SCRAPING',
  SCRAPING_PROGRESS: 'SCRAPING_PROGRESS',
  SCRAPING_COMPLETE: 'SCRAPING_COMPLETE',
  SCRAPING_ERROR: 'SCRAPING_ERROR',
  UPLOAD_COMPLETE: 'UPLOAD_COMPLETE',
  UPLOAD_ERROR: 'UPLOAD_ERROR',
  GET_STATUS: 'GET_STATUS'
}

// 状态类型
export const STATUS = {
  IDLE: 'idle',
  SCRAPING: 'scraping',
  UPLOADING: 'uploading',
  COMPLETED: 'completed',
  ERROR: 'error'
}

// 选择器配置（根据亚马逊页面结构调整）
export const SELECTORS = {
  // Amazon商品列表区域（重要！）
  SEARCH_AREA: '.sg-col-inner', // 主要商品列表区域

  // Amazon原生ASIN选择器
  ASIN_CONTAINER: '[data-asin]',
  ASIN_ATTRIBUTE: 'data-asin',
  LISTITEM_WITH_ASIN: '[role="listitem"][data-asin]',

  // 分页按钮（Amazon - 底部分页）
  PAGINATION_CONTAINER: '.s-pagination-container',
  NEXT_PAGE_BUTTON: 'a.s-pagination-next, .s-pagination-item.s-pagination-next',
  PREVIOUS_PAGE_BUTTON: 'a.s-pagination-previous, .s-pagination-item.s-pagination-previous',
  // 当前页码
  CURRENT_PAGE: '.s-pagination-item.s-pagination-selected',
  // 页码按钮（排除导航按钮和省略号）
  PAGE_NUMBERS: '.s-pagination-item:not(.s-pagination-previous):not(.s-pagination-next):not(.s-pagination-ellipsis)',
  // 产品列表容器
  PRODUCT_LIST: '.s-search-results, .s-main-slot'
}

// 爬取配置
export const SCRAPING_CONFIG = {
  // 页面加载等待时间（毫秒）
  PAGE_LOAD_DELAY: 2000,
  // 最大重试次数
  MAX_RETRIES: 3,
  // 重试延迟（毫秒）
  RETRY_DELAY: 1000
}
