/**
 * 亚马逊站点配置
 */

export const AMAZON_SITES = [
  { id: 203, code: 'IE', name: '爱尔兰', currency: 'EUR', domain: 'amazon.ie' },
  { id: 1, code: 'US', name: '美国', currency: 'USD', domain: 'amazon.com' },
  { id: 2, code: 'UK', name: '英国', currency: 'GBP', domain: 'amazon.co.uk' },
  { id: 3, code: 'DE', name: '德国', currency: 'EUR', domain: 'amazon.de' },
  { id: 4, code: 'FR', name: '法国', currency: 'EUR', domain: 'amazon.fr' },
  { id: 5, code: 'IT', name: '意大利', currency: 'EUR', domain: 'amazon.it' },
  { id: 6, code: 'ES', name: '西班牙', currency: 'EUR', domain: 'amazon.es' },
  { id: 7, code: 'JP', name: '日本', currency: 'JPY', domain: 'amazon.co.jp' },
  { id: 8, code: 'CA', name: '加拿大', currency: 'CAD', domain: 'amazon.ca' },
  { id: 9, code: 'AU', name: '澳大利亚', currency: 'AUD', domain: 'amazon.com.au' },
  { id: 10, code: 'MX', name: '墨西哥', currency: 'MXN', domain: 'amazon.com.mx' },
  { id: 11, code: 'BR', name: '巴西', currency: 'BRL', domain: 'amazon.com.br' },
  { id: 12, code: 'IN', name: '印度', currency: 'INR', domain: 'amazon.in' },
  { id: 13, code: 'SG', name: '新加坡', currency: 'SGD', domain: 'amazon.sg' },
  { id: 14, code: 'AE', name: '阿联酋', currency: 'AED', domain: 'amazon.ae' },
  { id: 15, code: 'SA', name: '沙特阿拉伯', currency: 'SAR', domain: 'amazon.sa' },
  { id: 121, code: 'NL', name: '荷兰', currency: 'EUR', domain: 'amazon.nl' },
  { id: 122, code: 'PL', name: '波兰', currency: 'PLN', domain: 'amazon.pl' },
  { id: 123, code: 'SE', name: '瑞典', currency: 'SEK', domain: 'amazon.se' },
  { id: 124, code: 'BE', name: '比利时', currency: 'EUR', domain: 'amazon.com.be' }
];

export const SITE_DOMAIN_MAP = AMAZON_SITES.reduce((map, site) => {
  map[site.code] = site.domain;
  return map;
}, {});

export function getSiteByHostname(hostname) {
  if (!hostname) return null;
  const host = hostname.toLowerCase();
  return AMAZON_SITES.find(site => host.includes(site.domain)) || null;
}

export function isAmazonUrl(url) {
  if (!url) return false;
  try {
    return getSiteByHostname(new URL(url).hostname) !== null;
  } catch {
    return false;
  }
}
