# 后台智能采集功能说明

## 📖 功能概述

浏览器插件现在支持**后台智能采集**功能！当你访问亚马逊商品列表页面时，插件会自动在后台采集ASIN，无需手动点击"开始采集"按钮。

## ✨ 功能特性

### 🤖 自动触发
- 访问商品列表页面（搜索结果、分类浏览、畅销榜等）时自动启动
- 页面加载完成后2秒自动开始采集
- 无需手动操作，节省时间

### 💫 页面浮动提示
在页面右上角显示优雅的浮动提示框：

```
┌──────────────────────────┐
│ 🤖 智能采集中            │
├──────────────────────────┤
│ ● 正在采集 ASIN...      │
│                          │
│ 当前页: 1   ASIN: 48    │
│                          │
│ [暂停] [停止]           │
└──────────────────────────┘
```

**提示框特性：**
- 🎨 渐变紫色背景，现代设计
- 💫 滑入动画效果
- 🔴 实时状态指示（采集中/暂停/停止）
- 📊 实时显示采集进度
- ⚡ 一键暂停/继续/停止
- ✨ 可手动关闭

### ⚙️ 灵活控制
- **开启/关闭**：在插件配置中可随时启用或禁用
- **暂停/继续**：采集过程中可以暂停和继续
- **停止采集**：随时停止当前采集
- **关闭提示**：不影响采集，可关闭提示框

## 🚀 使用方法

### 1. 启用功能

打开插件弹窗 → 展开"采集配置" → 找到"后台智能采集"开关：

```
┌─────────────────────────────────────────┐
│ ⚙️ 采集配置                             │
├─────────────────────────────────────────┤
│  🤖 后台智能采集                        │
│  （访问商品列表页时自动采集） ☑️ ON   │
└─────────────────────────────────────────┘
```

### 2. 访问商品列表页

打开任意亚马逊商品列表页，例如：
- 搜索结果：`https://www.amazon.com/s?k=laptop`
- 分类浏览：`https://www.amazon.com/b/...`
- 畅销榜：`https://www.amazon.com/gp/bestsellers`
- 新品榜：`https://www.amazon.com/gp/new-releases`

### 3. 自动采集

页面加载完成后：
1. **2秒后自动启动**采集
2. **右上角显示提示框**，实时显示进度
3. **自动采集所有ASIN**并上传到后端
4. **采集完成后自动隐藏**提示框

## 🎮 操作指南

### 提示框控制按钮

| 按钮 | 功能 | 说明 |
|------|------|------|
| **暂停** | 暂停采集 | 可以随时暂停采集过程 |
| **继续** | 恢复采集 | 从暂停处继续采集 |
| **停止** | 停止采集 | 完全停止当前采集任务 |
| **×** | 关闭提示 | 关闭提示框（不影响采集） |

### 状态指示

提示框中的圆点显示当前状态：

- 🟢 **绿色闪烁**：正在采集
- 🟡 **黄色静止**：已暂停
- 🔴 **红色静止**：已停止

## ⚙️ 设置说明

### 启用/禁用后台采集

1. 点击浏览器工具栏的插件图标
2. 展开"采集配置"面板
3. 切换"后台智能采集"开关
4. 设置立即生效

```javascript
// 启用后台采集（默认）
☑️ ON  - 访问商品列表页自动采集

// 禁用后台采集
☐ OFF - 需要手动点击"开始采集"
```

## 🔍 支持的页面类型

后台智能采集会在以下类型的页面自动启动：

1. **搜索结果页** - `/s?` 参数
2. **分类浏览页** - `/b/` 路径
3. **畅销榜** - `/gp/bestsellers`
4. **新品榜** - `/gp/new-releases`
5. **品牌店铺** - `/stores/` 路径
6. **细化搜索** - `rh=` 参数

## 💡 最佳实践

### 推荐使用场景
✅ 浏览多个商品列表页，需要快速采集
✅ 定期监控某个分类或搜索结果
✅ 批量采集畅销榜数据
✅ 自动化数据收集工作流

### 不推荐场景
❌ 商品详情页（不会触发）
❌ 首页、账户页面（不会触发）
❌ 需要精确控制采集时机
❌ 网络不稳定时

## 🛠️ 技术细节

### 文件结构
```
src/content/
├── content-script.js          # 主采集脚本
└── background-collector.js    # 后台采集器 ⭐新增
```

### 工作流程
```
1. 页面加载 (document_idle)
   ↓
2. 检测是否为商品列表页
   ↓
3. 检查后台采集是否启用
   ↓
4. 创建浮动提示框
   ↓
5. 2秒后自动开始采集
   ↓
6. 实时更新进度
   ↓
7. 采集完成/停止后隐藏提示
```

### 消息类型
```javascript
// 启动后台采集
chrome.runtime.sendMessage({
  type: 'BACKGROUND_COLLECT_START',
  data: { url, timestamp }
})

// 停止后台采集
chrome.runtime.sendMessage({
  type: 'BACKGROUND_COLLECT_STOP'
})
```

## 🎨 UI设计

### 提示框样式
- **位置**：固定在页面右上角（top: 80px, right: 20px）
- **背景**：渐变紫色（#667eea → #764ba2）
- **动画**：滑入效果（slideIn 0.3s）
- **尺寸**：最小宽度 240px，自适应高度
- **层级**：z-index: 999999（确保始终可见）

### 动画效果
- **进入动画**：从右侧滑入
- **状态圆点**：脉冲动画
- **图标**：上下浮动动画
- **按钮**：悬停放大效果

## ⚡ 性能优化

- ✅ 异步处理，不阻塞页面
- ✅ 防抖和节流机制
- ✅ 智能页面检测
- ✅ 最小化DOM操作
- ✅ 可随时停止

## 🔒 隐私安全

- ✅ 仅在亚马逊页面运行
- ✅ 本地控制开关
- ✅ 不收集额外数据
- ✅ 符合原有安全标准

## 📝 更新日志

### v2.6.0 (最新)
- ✨ 新增后台智能采集功能
- 🎨 添加页面浮动提示框
- ⚙️ 可配置开启/关闭
- 🎯 支持暂停/继续/停止控制
- 💫 优化用户体验

## 🆘 故障排查

### 提示框不显示
1. 检查是否在商品列表页面
2. 确认后台采集功能已启用
3. 查看浏览器控制台是否有错误
4. 尝试刷新页面

### 采集不自动开始
1. 检查页面URL是否符合规则
2. 等待2秒自动启动时间
3. 查看控制台日志
4. 手动点击"开始采集"按钮

### 提示框位置遮挡
- 提示框可以手动关闭（点击 ×）
- 不影响采集进程
- 建议在页面顶部留出空间

## 📧 反馈与支持

如有问题或建议，请：
1. 查看浏览器控制台日志
2. 检查插件配置
3. 提交 Issue 到 GitHub
4. 联系技术支持

---

**Happy Collecting! 🚀**

