# 发布流程文档

本文档描述了如何发布新版本的浏览器扩展。

## 前置条件

- 确保已安装 Node.js 和 npm。
- 确保已安装 PowerShell (Windows) 或 Bash (Linux/macOS)。
- 确保 `build-and-package.ps1` 和 `build-and-package.sh` 脚本具有执行权限。

## 发布步骤

1.  **更新版本号**

    - 修改 `package.json` 中的 `version` 字段。
    - 修改 `manifest.json` 中的 `version` 字段。
    - 更新 `CHANGELOG.md` 添加新版本的更新日志。

2.  **打包扩展**

    - 在项目根目录下运行以下命令：
      ```bash
      npm run package
      ```
    - 如果是在 Linux/macOS 环境下，运行：
      ```bash
      npm run package:linux
      ```
    - 脚本会自动：
      - 验证版本号一致性。
      - 生成 `extension.zip` 和 `extension.crx` (如果配置了私钥)。
      - 生成 `updates.json` 文件。
      - 将所有构建产物放入 `dist/` 目录。

3.  **测试**

    - 在 Chrome 浏览器中加载 `dist/unpacked` 目录，验证扩展功能是否正常。
    - 检查 `dist/updates.json` 中的版本号和下载链接是否正确。

4.  **发布**
    - 将 `dist/` 目录下的文件上传到服务器。
    - 确保 `updates.json` 的 URL 可以被公网访问。

## 自动化发布 (CI/CD)

本项目配置了 GitLab CI/CD 流程，当推送到 `main` 分支或打上 tag 时，会自动触发构建和发布流程。

- **触发条件**: Push to `main` or Tag creation.
- **产物**: 构建产物可在 CI/CD Pipeline 的 Artifacts 中下载。
