# 亚马逊站点配置参考

本文档列出了扩展支持的所有亚马逊站点及其配置信息。

## 支持的站点列表

| ID  | 代码 | 国家/地区      | 货币 | 域名              | API 端点                                            |
|-----|------|---------------|------|-------------------|-----------------------------------------------------|
| 203 | IE   | 爱尔兰        | EUR  | amazon.ie         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ie> |
| 1   | US   | 美国          | USD  | amazon.com        | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/us> |
| 2   | UK   | 英国          | GBP  | amazon.co.uk      | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/gb> |
| 3   | DE   | 德国          | EUR  | amazon.de         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/de> |
| 4   | FR   | 法国          | EUR  | amazon.fr         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/fr> |
| 5   | IT   | 意大利        | EUR  | amazon.it         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/it> |
| 6   | ES   | 西班牙        | EUR  | amazon.es         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/es> |
| 7   | JP   | 日本          | JPY  | amazon.co.jp      | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/jp> |
| 8   | CA   | 加拿大        | CAD  | amazon.ca         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ca> |
| 9   | AU   | 澳大利亚      | AUD  | amazon.com.au     | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/au> |
| 10  | MX   | 墨西哥        | MXN  | amazon.com.mx     | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/mx> |
| 11  | BR   | 巴西          | BRL  | amazon.com.br     | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/br> |
| 12  | IN   | 印度          | INR  | amazon.in         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/in> |
| 13  | SG   | 新加坡        | SGD  | amazon.sg         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/sg> |
| 14  | AE   | 阿联酋        | AED  | amazon.ae         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ae> |
| 15  | SA   | 沙特阿拉伯    | SAR  | amazon.sa         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/sa> |
| 121 | NL   | 荷兰          | EUR  | amazon.nl         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/nl> |
| 122 | PL   | 波兰          | PLN  | amazon.pl         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/pl> |
| 123 | SE   | 瑞典          | SEK  | amazon.se         | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/se> |
| 124 | BE   | 比利时        | EUR  | amazon.com.be     | <https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/be> |

## 区域分组

### 欧洲站点 (EUR)

- 🇩🇪 德国 (DE)
- 🇫🇷 法国 (FR)
- 🇮🇹 意大利 (IT)
- 🇪🇸 西班牙 (ES)
- 🇳🇱 荷兰 (NL)
- 🇮🇪 爱尔兰 (IE)
- 🇧🇪 比利时 (BE)

### 欧洲站点 (非EUR)

- 🇬🇧 英国 (GBP)
- 🇵🇱 波兰 (PLN)
- 🇸🇪 瑞典 (SEK)

### 北美站点

- 🇺🇸 美国 (USD)
- 🇨🇦 加拿大 (CAD)
- 🇲🇽 墨西哥 (MXN)

### 亚太站点

- 🇯🇵 日本 (JPY)
- 🇦🇺 澳大利亚 (AUD)
- 🇸🇬 新加坡 (SGD)
- 🇮🇳 印度 (INR)

### 中东站点

- 🇦🇪 阿联酋 (AED)
- 🇸🇦 沙特阿拉伯 (SAR)

### 南美站点

- 🇧🇷 巴西 (BRL)

## 如何添加新站点

如果亚马逊推出新的国际站点，可以按以下步骤添加：

1. **更新站点配置**
   - 编辑 `src/utils/amazon-sites.js`
   - 在 `AMAZON_SITES` 数组中添加新站点信息

2. **更新 manifest.json**
   - 在 `host_permissions` 中添加新域名
   - 在 `content_scripts.matches` 中添加新域名

3. **测试验证**
   - 访问新站点的商品列表页
   - 测试 ASIN 采集功能
   - 验证站点信息识别是否正确

4. **更新文档**
   - 更新 `README.md` 中的支持站点列表
   - 更新 `SITES.md` 中的站点表格
   - 更新 `CHANGELOG.md` 记录变更

## 示例测试 URL

为方便测试，以下是各站点的示例搜索页面：

- 美国: <https://www.amazon.com/s?k=laptop>
- 英国: <https://www.amazon.co.uk/s?k=laptop>
- 德国: <https://www.amazon.de/s?k=laptop>
- 法国: <https://www.amazon.fr/s?k=laptop>
- 日本: <https://www.amazon.co.jp/s?k=laptop>
- 加拿大: <https://www.amazon.ca/s?k=laptop>
- 澳大利亚: <https://www.amazon.com.au/s?k=laptop>
- 印度: <https://www.amazon.in/s?k=laptop>
- 新加坡: <https://www.amazon.sg/s?k=laptop>
- 阿联酋: <https://www.amazon.ae/s?k=laptop>

## 注意事项

1. **域名格式**
   - 大部分使用 `amazon.{国家代码}`
   - 特例：英国 `amazon.co.uk`、日本 `amazon.co.jp`
   - 特例：澳大利亚、墨西哥、巴西、比利时使用 `amazon.com.{国家代码}`

2. **站点ID**
   - 主要市场使用 1-15
   - 欧洲新市场使用 121-124
   - 爱尔兰使用 203

3. **API 端点**
   - 所有站点使用统一的 API 基础路径
   - 路径参数使用小写国家代码
   - 英国使用 `gb` 而非 `uk`
