/**
 * 亚马逊站点配置
 * 包含所有支持的亚马逊站点信息
 */

export const AMAZON_SITES = [
  {
    id: 203,
    code: 'IE',
    name: '爱尔兰',
    currency: 'EUR',
    domain: 'amazon.ie',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ie'
  },
  {
    id: 1,
    code: 'US',
    name: '美国',
    currency: 'USD',
    domain: 'amazon.com',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/us'
  },
  {
    id: 2,
    code: 'UK',
    name: '英国',
    currency: 'GBP',
    domain: 'amazon.co.uk',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/gb'
  },
  {
    id: 3,
    code: 'DE',
    name: '德国',
    currency: 'EUR',
    domain: 'amazon.de',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/de'
  },
  {
    id: 4,
    code: 'FR',
    name: '法国',
    currency: 'EUR',
    domain: 'amazon.fr',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/fr'
  },
  {
    id: 5,
    code: 'IT',
    name: '意大利',
    currency: 'EUR',
    domain: 'amazon.it',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/it'
  },
  {
    id: 6,
    code: 'ES',
    name: '西班牙',
    currency: 'EUR',
    domain: 'amazon.es',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/es'
  },
  {
    id: 7,
    code: 'JP',
    name: '日本',
    currency: 'JPY',
    domain: 'amazon.co.jp',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/jp'
  },
  {
    id: 8,
    code: 'CA',
    name: '加拿大',
    currency: 'CAD',
    domain: 'amazon.ca',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ca'
  },
  {
    id: 9,
    code: 'AU',
    name: '澳大利亚',
    currency: 'AUD',
    domain: 'amazon.com.au',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/au'
  },
  {
    id: 10,
    code: 'MX',
    name: '墨西哥',
    currency: 'MXN',
    domain: 'amazon.com.mx',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/mx'
  },
  {
    id: 11,
    code: 'BR',
    name: '巴西',
    currency: 'BRL',
    domain: 'amazon.com.br',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/br'
  },
  {
    id: 12,
    code: 'IN',
    name: '印度',
    currency: 'INR',
    domain: 'amazon.in',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/in'
  },
  {
    id: 13,
    code: 'SG',
    name: '新加坡',
    currency: 'SGD',
    domain: 'amazon.sg',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/sg'
  },
  {
    id: 14,
    code: 'AE',
    name: '阿联酋',
    currency: 'AED',
    domain: 'amazon.ae',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/ae'
  },
  {
    id: 15,
    code: 'SA',
    name: '沙特阿拉伯',
    currency: 'SAR',
    domain: 'amazon.sa',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/sa'
  },
  {
    id: 121,
    code: 'NL',
    name: '荷兰',
    currency: 'EUR',
    domain: 'amazon.nl',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/nl'
  },
  {
    id: 122,
    code: 'PL',
    name: '波兰',
    currency: 'PLN',
    domain: 'amazon.pl',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/pl'
  },
  {
    id: 123,
    code: 'SE',
    name: '瑞典',
    currency: 'SEK',
    domain: 'amazon.se',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/se'
  },
  {
    id: 124,
    code: 'BE',
    name: '比利时',
    currency: 'EUR',
    domain: 'amazon.com.be',
    api: 'https://amazon.zying.net/api/zbig/MoreAboutAsin/v2/be'
  }
]

/**
 * 根据主机名获取站点信息
 * @param {string} hostname - 主机名（如 www.amazon.com）
 * @returns {Object|null} 站点信息对象
 */
export function getSiteByHostname(hostname) {
  if (!hostname) return null

  const normalizedHost = hostname.toLowerCase()

  for (const site of AMAZON_SITES) {
    if (normalizedHost.includes(site.domain)) {
      return site
    }
  }

  return null
}

/**
 * 检查URL是否为亚马逊站点
 * @param {string} url - 完整URL
 * @returns {boolean}
 */
export function isAmazonUrl(url) {
  if (!url) return false

  try {
    const hostname = new URL(url).hostname
    return getSiteByHostname(hostname) !== null
  } catch (error) {
    return false
  }
}

/**
 * 获取所有支持的域名（用于manifest配置）
 * @returns {string[]} 域名数组
 */
export function getAllDomains() {
  return AMAZON_SITES.map(site => site.domain)
}

/**
 * 获取所有支持的域名匹配模式（用于manifest配置）
 * @returns {string[]} 匹配模式数组
 */
export function getAllDomainPatterns() {
  return AMAZON_SITES.map(site => `https://*.${site.domain}/*`)
}
