# 图标文件

此目录应包含以下图标文件：

- `icon16.png` - 16x16 像素
- `icon48.png` - 48x48 像素
- `icon128.png` - 128x128 像素

## 如何创建图标

### 方法 1: 使用在线工具

1. **Favicon Generator**
   - 访问: <https://realfavicongenerator.net/>
   - 上传您的原始图片
   - 下载生成的图标包

2. **Icon Kitchen**
   - 访问: <https://icon.kitchen/>
   - 设计您的图标
   - 导出为 PNG 格式

### 方法 2: 使用设计工具

使用 Photoshop、GIMP、Figma 等设计工具创建：

1. 创建 128x128 像素的设计
2. 导出为 PNG 格式
3. 使用图像编辑工具调整到其他尺寸（16x16、48x48）

### 方法 3: 临时占位符

如果您只是想快速测试插件，可以使用纯色占位符：

```html
<!-- 创建简单的 SVG 图标 -->
<svg width="128" height="128" xmlns="http://www.w3.org/2000/svg">
  <rect width="128" height="128" fill="#667eea"/>
  <text x="50%" y="50%" text-anchor="middle" dy=".3em"
        fill="white" font-size="48" font-family="Arial">A</text>
</svg>
```

然后转换为 PNG 格式。

## 设计建议

- 使用简洁的设计，确保在小尺寸下仍然清晰可辨
- 使用与插件主题相符的颜色（例如：#667eea）
- 考虑使用字母 "A"（ASIN）或购物车图标
- 确保图标在深色和浅色背景下都清晰可见
- PNG 格式，透明背景

## 图标示例概念

```
🔍 - 搜索/采集的概念
📦 - ASIN/产品的概念
🛒 - 电商的概念
```

一个好的设计可能是：紫色渐变背景 + 白色放大镜 + 字母 "A"
