/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 2:
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.waitDom = exports.sleep = exports.setStorage = exports.getStorage = exports.getCurrentDate = exports.addToClipBoard = exports.showMsg = void 0; // 添加消息

var style = document.createElement('style');
style.innerText = "\n@media (min-width: 100px){\n  .plugin-pop-cls{\n    position: fixed;\n    width:100vw;\n    top:0vh;\n    height: 1px;\n    text-align: center;\n    z-index:100000;\n    left: 0;\n  }\n}\n\n@media (min-width: 900px){\n  .plugin-pop-cls{\n    position: fixed;\n    width:30vw;\n    top:15vh;\n    height: 1px;\n    left:34vw;\n    text-align: center;\n    z-index:100000\n  }\n}\n\n\n.plugin-alert{\n  width:100%;\n  font-size:14px;\n  padding:10px;\n  text-align: center;\n  margin-bottom: 20px;\n  border-width: 1px;\n  border-style: solid;\n  border-radius: 4px;\n}\n.plugin-success{\n  color:rgb(60, 118, 61);\n  background-color: rgb(223, 240, 216);\n  border-color: rgb(214, 233, 198);\n}\n.plugin-warning{\n  color: #a94442;\n  background-color: #f2dede;\n  border-color: #ebccd1;\n}\ninput,button,select,textarea{outline:none}";

var _interval = setInterval(function () {
  if (document.head) {
    clearInterval(_interval);
    document.head.appendChild(style);
  }
}, 2000);

function showMsg(title) {
  var status = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "success";
  var during = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 2000;

  if ($('.plugin-pop-cls').length == 0) {
    $('body').append('<div class="plugin-pop-cls"></div>');
  }

  var cls = "cls" + new Date().getTime();
  var statusClass = '';

  if (status == 'success') {
    statusClass = 'plugin-success';
  } else {
    statusClass = 'plugin-warning';
  }

  $('.plugin-pop-cls').append("<div class=\"plugin-alert ".concat(cls, " ").concat(statusClass, "\">").concat(title, "</div>"));
  setTimeout(function () {
    $(".".concat(cls)).remove();
  }, during);
}

exports.showMsg = showMsg; // 复制到剪切板

function addToClipBoard(str) {
  var transfer = document.createElement('input');
  $('body').append(transfer);
  transfer.value = str;
  transfer.focus();
  transfer.select();

  if (document.execCommand('copy')) {
    document.execCommand('copy');
  }

  transfer.blur();
  $('body input').remove();
}

exports.addToClipBoard = addToClipBoard; // 获取当前日期

function getCurrentDate() {
  var current_date = new Date();
  var years = current_date.getFullYear();
  var month = current_date.getMonth() + 1;
  month = month < 10 ? '0' + month : month;
  var day = current_date.getDate();
  day = day < 10 ? '0' + day : day;
  var hours = current_date.getHours();
  var minute = current_date.getMinutes();
  return [years, month, day, hours, minute];
}

exports.getCurrentDate = getCurrentDate;

function getClipInfo() {
  var helperdiv = document.createElement("div");
  document.body.appendChild(helperdiv);
  helperdiv.contentEditable = true; // focus the helper div's content

  var range = document.createRange();
  range.selectNode(helperdiv);
  var selection = window.getSelection();
  selection && selection.removeAllRanges();
  selection && selection.addRange(range);
  helperdiv.focus(); // trigger the paste action

  document.execCommand("Paste"); // read the clipboard contents from the helperdiv

  var clipboardContents = helperdiv.innerHTML;
  console.log("\u5F53\u524D\u526A\u5207\u677F\u5185\u5BB9\u4E3A:".concat(clipboardContents));
  document.body.removeChild(helperdiv);
  return clipboardContents;
}

function getStorage(_arr) {
  return new Promise(function (resolve) {
    chrome.storage.local.get(_arr, function (res) {
      resolve(res);
    });
  });
}

exports.getStorage = getStorage;

function setStorage(obj) {
  return new Promise(function (resolve) {
    chrome.storage.local.set(obj, function () {
      resolve('');
    });
  });
}

exports.setStorage = setStorage;

function sleep(ts) {
  return new Promise(function (resolve) {
    setTimeout(function () {
      resolve('');
    }, ts);
  });
}

exports.sleep = sleep;

function waitDom(dom) {
  return new Promise(function (resolve) {
    var interval = setInterval(function () {
      if ($(dom).length) {
        clearInterval(interval);
        resolve('');
      }
    }, 100);
  });
}

exports.waitDom = waitDom;

/***/ }),

/***/ 12:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var tools_1 = __webpack_require__(2);

var ContentScript = /*#__PURE__*/function () {
  function ContentScript() {
    _classCallCheck(this, ContentScript);

    // 购物车页面
    this.cartPageFinish = false;
    this.cartPageWaitLoadTime = 20; // 监听页面加载 

    this.listenAjaxPage = false; // interval

    this.requestInterval = '5-8';
    this.listenPaginationTimeout = '';
    this.minPriceObj = {
      com: 7,
      jp: 800,
      ca: 10
    };
    this.minPriceVal = 0;
  }

  _createClass(ContentScript, [{
    key: "init",
    value: function init() {
      var _this2 = this;

      // asin 详情页
      if (location.href.includes('https://www.amazon.com/dp/')) {
        chrome.storage.local.get('mode', function (res) {
          if (res.mode == 'collectData') {
            chrome.storage.local.set({
              'lastTime': new Date().getTime()
            });
            var interval = setInterval(function () {
              if (document.documentElement.innerHTML.includes("Sorry! Something went wrong") || document.documentElement.innerHTML.includes("Sorry! We couldn't find that page")) {
                clearInterval(interval);
                chrome.storage.local.get('failCount', function (res) {
                  if (!(res === null || res === void 0 ? void 0 : res.failCount)) {
                    res.failCount = 0;
                  }

                  res.failCount += 1;
                  chrome.storage.local.set(res);

                  if (res.failCount < 3) {
                    setTimeout(function () {
                      _this2.getRandomAsin();
                    }, 2000);
                  }
                });
              }
            }, 2000);
            var timeout = setTimeout(function () {
              if (!$('[aria-label="exclamation-circle"], [aria-label="check-circle"]:visible').length && $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').length) {
                // clearInterval(sellerInterval)
                _this2.zhiyinglogin();

                return false;
              }
            }, 10 * 1000);

            _this2.asinCartData();
          }
        }); // 店铺页
      } else if (location.href.includes('https://www.amazon.com/sp')) {
        chrome.storage.local.get('mode', function (res) {
          if (res.mode == 'collectData') {
            chrome.storage.local.set({
              'lastTime': new Date().getTime()
            });
            setInterval(function () {
              if (location.href.includes('https://www.amazon.com/sp') && $('#seller-info-storefront-link').length) {
                $('#seller-info-storefront-link a').eq(0)[0].click();
              }
            }, 10 * 1000);
            setTimeout(function () {
              _this2.getRandomAsin();
            }, 60 * 1000);
          }
        }); // 店铺商品列表页
      } else if (location.href.includes('https://www.amazon.com/s?')) {
        // 添加按钮到页面
        // this.addStartButton()
        chrome.storage.local.get(['mode'], function (res) {
          return __awaiter(_this2, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    console.log('getRunStatus', res);

                    if (!((res === null || res === void 0 ? void 0 : res.mode) != 'collectData')) {
                      _context.next = 3;
                      break;
                    }

                    return _context.abrupt("return", false);

                  case 3:
                    this._startCollect();

                  case 4:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee, this);
          }));
        });
      } // 监听消息


      this.listenBgMessage(); // 设置最低价
      // this.setMinPrice()
      // 获取定时器

      (0, tools_1.getStorage)(['interval']).then(function (res) {
        _this2.requestInterval = (res.interval || '5-8').split('-');
      });
    } // 添加开始按钮

  }, {
    key: "addStartButton",
    value: function addStartButton() {
      var _this = this;

      $('.s-card-container').wait(function () {
        return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  _context2.next = 2;
                  return (0, tools_1.sleep)(2000);

                case 2:
                  $(this).each(function () {
                    $(this).append("<button class=\"selectStart\">\u4F5C\u4E3A\u8D77\u70B9</button>");
                  });

                case 3:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2, this);
        }));
      }); // 按钮被点击 开始执行

      $('body').on('click', '.selectStart', function () {
        return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
          var that, brandLoad, brandStatus, result, url;
          return _regeneratorRuntime().wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  chrome.storage.local.set({
                    country: 'us',
                    lastTime: new Date().getTime()
                  });
                  that = $(this).parents('div.s-result-item'); // let brandStatus = $(that).find('[aria-label="exclamation-circle"], [aria-label="check-circle"].anticon-check-circle')

                  brandLoad = $(that).find('[aria-label="exclamation-circle"], [aria-label="check-circle"]');
                  brandStatus = $(that).find('[aria-label="exclamation-circle"]'); // let cartNumber = ($(that).find('[data-action="show-all-offers-display"]').text() || '').match(/\d+/) || ''

                  console.log('brandStatus', brandLoad, brandStatus);
                  chrome.storage.local.set({
                    mode: "collectData"
                  });

                  if (!(!brandLoad.length || brandStatus.length)) {
                    _context3.next = 10;
                    break;
                  }

                  console.log('不符合');

                  _this.getRandomAsin();

                  return _context3.abrupt("return", false);

                case 10:
                  _context3.next = 12;
                  return _this._getCartShop(that, 'start');

                case 12:
                  result = _context3.sent;

                  if (result.length) {
                    _context3.next = 16;
                    break;
                  }

                  // chrome.storage.local.remove('mode')
                  // alert('起点不符合 起点要求：购物车内未找到可扩列的店铺')
                  // return false
                  _this.getRandomAsin();

                  return _context3.abrupt("return", false);

                case 16:
                  // console.log('result', result)
                  url = result.shift();
                  chrome.storage.local.set({
                    shopList: result
                  }, function () {
                    location.href = "https://www.amazon.com/s?me=".concat(url, "&marketplaceID=").concat(url);
                  });

                case 18:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3, this);
        }));
      });
    } // 获取运行状态

  }, {
    key: "getRunStatus",
    value: function getRunStatus() {
      var _this3 = this;

      chrome.storage.local.get(['mode'], function (res) {
        return __awaiter(_this3, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
          return _regeneratorRuntime().wrap(function _callee4$(_context4) {
            while (1) {
              switch (_context4.prev = _context4.next) {
                case 0:
                  console.log('getRunStatus', res);

                  if (!((res === null || res === void 0 ? void 0 : res.mode) != 'collectData')) {
                    _context4.next = 3;
                    break;
                  }

                  return _context4.abrupt("return", false);

                case 3:
                  this._startCollect();

                case 4:
                case "end":
                  return _context4.stop();
              }
            }
          }, _callee4, this);
        }));
      });
    } // 收集购物车商家

  }, {
    key: "_getCartShop",
    value: function _getCartShop(dom) {
      var mode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "run";
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
        var contentStatus, shopObj, shopDom, _i, _shopDom, row, start, shop, soldBy, sellerId;

        return _regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                console.log('开始执行购物车页面');
                _context5.next = 3;
                return (0, tools_1.sleep)(1000);

              case 3:
                this.cartPageFinish = true;
                $(dom).find('[data-action="show-all-offers-display"]')[0].click();
                console.log('开始等待');

              case 6:
                if (!this.cartPageFinish) {
                  _context5.next = 11;
                  break;
                }

                _context5.next = 9;
                return (0, tools_1.sleep)(1000);

              case 9:
                _context5.next = 6;
                break;

              case 11:
                console.log('请求完成');
                _context5.next = 14;
                return waitDom('#aod-container #aod-pinned-offer, #aod-offer-list > div', 20);

              case 14:
                contentStatus = _context5.sent;
                console.log('页面样式加载完成');

                if (contentStatus) {
                  _context5.next = 20;
                  break;
                }

                if (!(mode == 'start')) {
                  _context5.next = 20;
                  break;
                }

                alert('购物车内容加载超时');
                return _context5.abrupt("return", false);

              case 20:
                _context5.next = 22;
                return (0, tools_1.sleep)(3000);

              case 22:
                shopObj = [];
                shopDom = Array.from($('#aod-container #aod-pinned-offer, #aod-offer-list > div'));
                console.log('shopDom', shopDom);

                for (_i = 0, _shopDom = shopDom; _i < _shopDom.length; _i++) {
                  row = _shopDom[_i];
                  start = ($(row).find('#aod-offer-seller-rating').text() || '').match(/[\d]+(?= rating)/); // console.log('start', start)

                  start = start ? parseInt(start[0]) : 0;

                  if (start < 100) {
                    shop = $(row).find('#aod-offer-soldBy a[role="link"]').attr('href') || '';
                    soldBy = $(row).find('.a-fixed-left-grid:contains(Ships from)').find('span').eq(1).text();

                    if (!soldBy.includes('Amazon')) {
                      sellerId = shop.match(/(?<=seller=).*?(?=&)/);
                      sellerId = sellerId ? sellerId[0] : "";

                      if (sellerId) {
                        shopObj.push(sellerId);
                      }
                    }
                  }
                }

                console.log('shopObj', shopObj);

                if (!shopObj.length) {
                  _context5.next = 32;
                  break;
                }

                _context5.next = 30;
                return this.checkShopFit(shopObj);

              case 30:
                shopObj = _context5.sent;
                shopObj = shopObj.data;

              case 32:
                $('#aod-close i')[0].click();
                _context5.next = 35;
                return (0, tools_1.sleep)(2000);

              case 35:
                return _context5.abrupt("return", shopObj);

              case 36:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));
    } // 开始收集数据

  }, {
    key: "_startCollect",
    value: function _startCollect() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
        var _this4 = this;

        var _this, _timeout;

        return _regeneratorRuntime().wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                chrome.storage.local.set({
                  'lastTime': new Date().getTime()
                });
                _this = this; //  等待30s 如果页面没有出现商品  切换店铺

                _timeout = setTimeout(function () {
                  return __awaiter(_this4, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee6() {
                    return _regeneratorRuntime().wrap(function _callee6$(_context6) {
                      while (1) {
                        switch (_context6.prev = _context6.next) {
                          case 0:
                            _this.runNext();

                          case 1:
                          case "end":
                            return _context6.stop();
                        }
                      }
                    }, _callee6);
                  }));
                }, 100 * 1000); // 等待加载完成

                _context8.next = 5;
                return this.sellerLoadFinish();

              case 5:
                console.log('开始执行');
                $('.s-widget-spacing-small').wait(function () {
                  var _this5 = this;

                  console.log('开始检测asin');
                  clearTimeout(_timeout);
                  var asinList = [];
                  $(this).each(function () {
                    asinList.push($(this).attr('data-asin'));
                  });
                  console.log('asin 列表', asinList);
                  chrome.runtime.sendMessage({
                    type: "http",
                    url: "https://www.genmaijl.com/ai/asin/check?asin=".concat(asinList.join(','), "&country=").concat(_this.getCountry()),
                    // url: `http://127.0.0.1:8000/ai/asin/check?asin=${asinList.join(',')}&country=${_this.getCountry()}`,
                    content: {
                      method: 'get'
                    }
                  }, function (res) {
                    return __awaiter(_this5, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee7() {
                      var _iterator, _step, row;

                      return _regeneratorRuntime().wrap(function _callee7$(_context7) {
                        while (1) {
                          switch (_context7.prev = _context7.next) {
                            case 0:
                              console.log('asin检测完成', res);

                              if (res.code == 0) {
                                _iterator = _createForOfIteratorHelper(res.data);

                                try {
                                  for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                    row = _step.value;
                                    $("div[data-asin=\"".concat(row.asin, "\"]")).attr('collected', 'yes');
                                  }
                                } catch (err) {
                                  _iterator.e(err);
                                } finally {
                                  _iterator.f();
                                }
                              } // await _this.checkBrand()


                              _this.circulationRequest();

                            case 3:
                            case "end":
                              return _context7.stop();
                          }
                        }
                      }, _callee7);
                    }));
                  });
                });

              case 7:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));
    }
  }, {
    key: "circulationRequest",
    value: function circulationRequest() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee9() {
        var _this6 = this;

        var domList, totalSend, _loop, _i2, _domList, _ret;

        return _regeneratorRuntime().wrap(function _callee9$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                chrome.storage.local.set({
                  'lastTime': new Date().getTime()
                }); //开始获取数据

                domList = Array.from($('._1wyo2vd4, ._1wyo2vdc'));

                if (!(!$('[aria-label="exclamation-circle"]:visible, [aria-label="check-circle"]:visible').length && $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').length)) {
                  _context10.next = 5;
                  break;
                }

                this.zhiyinglogin();
                return _context10.abrupt("return", false);

              case 5:
                // $('._1wyo2vd4, ._1wyo2vdc').each(function (this: any) {
                totalSend = 0;
                _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
                  var row, that, asin, price, sell_number, sell_type, sort, firstCate, asinFit, sell_amount, data;
                  return _regeneratorRuntime().wrap(function _loop$(_context9) {
                    while (1) {
                      switch (_context9.prev = _context9.next) {
                        case 0:
                          row = _domList[_i2];
                          that = $(row).parents('.s-widget-spacing-small');
                          asin = $(that).attr('data-asin');
                          price = ($(that).find('.a-offscreen').eq(0).text() || '').match(/[\d,.]+/);
                          price = price ? price[0] : "0";

                          if (!(parseFloat(price) <= 7 && false)) {
                            _context9.next = 8;
                            break;
                          }

                          console.log("\u4EF7\u683C\u4E0D\u7B26\u5408\uFF1A asin:".concat(asin), price);
                          return _context9.abrupt("return", "continue");

                        case 8:
                          sell_number = ($(that).find('a[data-action="show-all-offers-display"]').eq(0).text() || '0').match(/[\d]+/);
                          sell_number = sell_number ? sell_number[0] : '0';

                          if (!(parseInt(sell_number) < 2)) {
                            _context9.next = 13;
                            break;
                          }

                          console.log("\u8D2D\u7269\u8F66\u4E0D\u7B26\u5408\uFF1A asin:".concat(asin), sell_number);
                          return _context9.abrupt("return", "continue");

                        case 13:
                          if (!$(that).attr('collected')) {
                            _context9.next = 16;
                            break;
                          }

                          console.log("asin\u5DF2\u7ECF\u91C7\u96C6 asin:".concat(asin));
                          return _context9.abrupt("return", "continue");

                        case 16:
                          sell_type = $(that).find('.zying-tag-ship._1wyo2vd2g').text();

                          if (!(sell_type != 'FBM')) {
                            _context9.next = 20;
                            break;
                          }

                          console.log("\u7269\u6D41\u7C7B\u578B\u4E0D\u7B26\u5408 asin:".concat(asin, ",").concat(sell_type));
                          return _context9.abrupt("return", "continue");

                        case 20:
                          sort = [];
                          $(that).find('.ranktag').each(function () {
                            sort.push($(this).text().trim() + $(this).next().text().trim());
                          });

                          if (sort.length) {
                            _context9.next = 24;
                            break;
                          }

                          return _context9.abrupt("return", "continue");

                        case 24:
                          firstCate = sort[0].match(/[\d]+/);
                          firstCate = firstCate ? firstCate[0] : '10000000';
                          asinFit = false;
                          sell_amount = $(that).find('._1wyo2vd2b:contains(30天销量) span>span').text() || '';
                          sell_amount = sell_amount.match(/[\d]+/);
                          sell_amount = sell_amount ? parseInt(sell_amount[0]) : 0;

                          if (sort[0].includes('Clothing, Shoes & Jewelry') && parseInt(firstCate) < 1200000) {
                            asinFit = true;
                          }

                          if (sell_amount > 50) {
                            asinFit = true;
                          }

                          if (asinFit) {
                            _context9.next = 35;
                            break;
                          }

                          console.log('排名/销量不符合', asin, sort[0], sell_amount, firstCate);
                          return _context9.abrupt("return", "continue");

                        case 35:
                          // if (!(parseInt(firstCate) < 1200000 && sort[0].includes('Clothing, Shoes & Jewelry')) || ) {
                          // if (parseInt(firstCate) > 1200000) {
                          //   console.log('排名不符合', asin, sort, firstCate)
                          //   continue;
                          // }
                          data = {
                            asin: asin,
                            h10_seller: '',
                            cart_price: parseFloat(price),
                            title: $(that).find('h2>span').text().trim(),
                            mainImg: $(that).find('img.s-image').attr('src'),
                            brand: $(that).find('._1wyo2vd18._1wyo2vdw._1wyo2vd6').text().trim() || '',
                            seller_number: sell_number,
                            seller_type: sell_type,
                            sort: JSON.stringify(sort),
                            country: _this6.getCountry(),
                            market_id: _this6.getRequestParams('marketplaceID')
                          };
                          totalSend += 1;
                          chrome.runtime.sendMessage({
                            type: "http",
                            url: "https://www.genmaijl.com/ai/asin/upload",
                            // url: "http://127.0.0.1:8000/ai/asin/upload",
                            content: {
                              method: 'post',
                              body: JSON.stringify(data)
                            }
                          }, function () {
                            (0, tools_1.getStorage)(['sendTotal', 'lastTime']).then(function (res) {
                              if (!(res === null || res === void 0 ? void 0 : res.sendTotal)) {
                                res.sendTotal = {};
                              }

                              res['lastTime'] = new Date().getTime();
                              var timer = res.sendTotal[new Date().toLocaleDateString()] || 0;
                              timer += 1;
                              res.sendTotal[new Date().toLocaleDateString()] = timer;
                              (0, tools_1.setStorage)(res);
                            });
                          });
                          _context9.next = 40;
                          return (0, tools_1.sleep)(2000);

                        case 40:
                        case "end":
                          return _context9.stop();
                      }
                    }
                  }, _loop);
                });
                _i2 = 0, _domList = domList;

              case 8:
                if (!(_i2 < _domList.length)) {
                  _context10.next = 16;
                  break;
                }

                return _context10.delegateYield(_loop(), "t0", 10);

              case 10:
                _ret = _context10.t0;

                if (!(_ret === "continue")) {
                  _context10.next = 13;
                  break;
                }

                return _context10.abrupt("continue", 13);

              case 13:
                _i2++;
                _context10.next = 8;
                break;

              case 16:
                _context10.next = 18;
                return (0, tools_1.sleep)(2000);

              case 18:
                console.log('采集结束'); // return false;

                this.runNext(totalSend);

              case 20:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee9, this);
      }));
    }
  }, {
    key: "listenBgMessage",
    value: function listenBgMessage() {
      var _this7 = this;

      chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
        switch (request.type) {
          case 'requestFinish':
            if (_this7.listenAjaxPage) {
              // clearTimeout(this.listenPaginationTimeout)
              setTimeout(function () {
                _this7._startCollect();
              }, 2000);
            } else if (_this7.cartPageFinish) {
              _this7.cartPageFinish = false;
            }

            break;

          case 'h10Finish':
            // this.currentBusyNum = 0
            // this.circulationRequest()
            break;

          case 'reload':
            window.location.reload();
            break;
        }
      });
    }
  }, {
    key: "sellerLoadFinish",
    value: function sellerLoadFinish() {
      var _this8 = this;

      return new Promise(function (resolve) {
        return __awaiter(_this8, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee10() {
          var _this9 = this;

          var maxCount, sellerInterval, timeout;
          return _regeneratorRuntime().wrap(function _callee10$(_context11) {
            while (1) {
              switch (_context11.prev = _context11.next) {
                case 0:
                  maxCount = 0;
                  console.log('等待智赢加载', $('[aria-label="exclamation-circle"], [aria-label="check-circle"]').length, $('[role="listitem"]').length);
                  sellerInterval = setInterval(function () {
                    maxCount += 1;

                    if ($('[aria-label="exclamation-circle"], [aria-label="check-circle"]').length / $('[role="listitem"]').length > 0.7) {
                      localStorage.removeItem('failCount');
                      console.log('智赢加载完成');
                      clearInterval(sellerInterval);
                      clearTimeout(timeout);
                      setTimeout(function () {
                        resolve('');
                      }, 5000);
                    }

                    if (maxCount > 30 && $('[aria-label="exclamation-circle"], [aria-label="check-circle"]').length == 0) {
                      clearInterval(sellerInterval);
                      var count = localStorage.getItem('failCount') || '0';
                      count = parseInt(count) + 1;

                      if (count > 2) {
                        localStorage.removeItem('failCount');

                        _this9.getRandomAsin();

                        return false;
                      } else {
                        localStorage.setItem('failCount', count);
                        location.reload();
                      }
                    }
                  }, 2000);
                  timeout = setTimeout(function () {
                    if (!$('[aria-label="exclamation-circle"]:visible, [aria-label="check-circle"]:visible').length && $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').length) {
                      clearInterval(sellerInterval);

                      _this9.zhiyinglogin();

                      return false;
                    }
                  }, 10 * 1000);

                case 4:
                case "end":
                  return _context11.stop();
              }
            }
          }, _callee10);
        }));
      });
    }
  }, {
    key: "checkShopFit",
    value: function checkShopFit(arr) {
      var _this10 = this;

      return new Promise(function (resolve) {
        chrome.runtime.sendMessage({
          type: "http",
          url: "https://www.genmaijl.com/ai/asin/checkShop",
          // url: "http://127.0.0.1:8000/ai/asin/checkShop",
          content: {
            method: "post",
            headers: {
              "Content-Type": "application/json"
            },
            body: JSON.stringify({
              shopList: arr,
              country: _this10.getCountry()
            })
          }
        }, function (res) {
          resolve(res);
        });
      });
    }
  }, {
    key: "runNext",
    value: function runNext() {
      var number = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee11() {
        var _this11 = this;

        var next;
        return _regeneratorRuntime().wrap(function _callee11$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                // 运行下一步

                /**
                 * 翻页的条件
                 * 页面上百分之60 是不侵权的
                 * 不侵权的数据中百分之50是销量大于30的
                 *
                 */
                next = $('span.s-pagination-selected').parents('ul').find('a:contains(Next)');

                if ($(next).length && parseInt($('span.s-pagination-selected').text()) < 6) {
                  console.log('nextPage');
                  this.listenAjaxPage = true;
                  $(next)[0].click();
                } else {
                  chrome.storage.local.get(['shopList'], function (res) {
                    var url = res === null || res === void 0 ? void 0 : res.shopList.shift();

                    if (!url) {
                      // alert('店铺使用完毕 请重新选择起点')
                      // return false;
                      _this11.getRandomAsin();

                      return false;
                    }

                    var href = "https://www.amazon.com/s?me=".concat(url, "&marketplaceID=").concat(url);
                    chrome.storage.local.set(res);
                    setTimeout(function () {
                      location.href = href;
                    }, 3000);
                  });
                }

              case 2:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee11, this);
      }));
    }
  }, {
    key: "getCountry",
    value: function getCountry() {
      var platform = '';
      var host = window.location.host;
      host = host.split('.').pop();

      if (host == 'ca') {
        platform = "加拿大";
      } else if (host == 'com') {
        platform = '美国';
      } else if (host == 'jp') {
        platform = '日本';
      } else if (host == 'de') {
        platform = '德国';
      } else if (host == 'fr') {
        platform = '法国';
      }

      return platform;
    }
  }, {
    key: "setMinPrice",
    value: function setMinPrice() {
      var host = window.location.host;
      host = host.split('.').pop();
      this.minPriceVal = this.minPriceObj[host];
    }
  }, {
    key: "checkAmazonBusy",
    value: function checkAmazonBusy() {
      var _this12 = this;

      return new Promise(function (resolve) {
        return __awaiter(_this12, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee12() {
          var errorCount;
          return _regeneratorRuntime().wrap(function _callee12$(_context13) {
            while (1) {
              switch (_context13.prev = _context13.next) {
                case 0:
                  _context13.next = 2;
                  return (0, tools_1.sleep)(3000);

                case 2:
                  // 检测亚马逊是否频繁了
                  if (document.documentElement.innerHTML.includes("Sorry! Something went wrong") || document.documentElement.innerHTML.includes("Sorry! We couldn't find that page")) {
                    errorCount = localStorage.getItem('errorCount') || '0';

                    if (errorCount == '3') {
                      localStorage.clear();
                      chrome.runtime.sendMessage({
                        type: 'changeIp'
                      });
                      resolve(false);
                    } else {
                      errorCount = parseInt(errorCount) + 1;
                      localStorage.setItem('errorCount', errorCount);
                      setTimeout(function () {
                        window.location.reload();
                      }, 10 * 1000);
                    }
                  } else if (document.documentElement.innerHTML.includes('Enter the characters you see below')) {
                    chrome.runtime.sendMessage({
                      type: 'changeIp'
                    });
                    resolve(false);
                  } else if ($('nav-line-2 nav-progressive-content').text().includes('China')) {
                    resolve(false);
                  } else {
                    localStorage.removeItem('errorCount');
                    resolve(true);
                  }

                case 3:
                case "end":
                  return _context13.stop();
              }
            }
          }, _callee12);
        }));
      });
    }
  }, {
    key: "getRequestParams",
    value: function getRequestParams(key) {
      var url = location.search;
      var theRequest = {};

      if (url.indexOf("?") != -1) {
        var str = url.substr(1);
        var strs = str.split("&");

        for (var i = 0; i < strs.length; i++) {
          theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
        }
      }

      var value = theRequest[key];
      return value;
    }
  }, {
    key: "getRandomAsin",
    value: function getRandomAsin() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee13() {
        var randomValue;
        return _regeneratorRuntime().wrap(function _callee13$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                chrome.storage.local.set({
                  'lastTime': new Date().getTime()
                });
                randomValue = Math.random() * (parseInt(this.requestInterval[1]) - parseInt(this.requestInterval[0])) + parseInt(this.requestInterval[0]);
                _context14.next = 4;
                return (0, tools_1.sleep)(randomValue * 1000);

              case 4:
                chrome.runtime.sendMessage({
                  type: "http",
                  url: "https://www.genmaijl.com/ai/asin/getRandomAsin?country=us&t=".concat(new Date().getTime(), "}"),
                  // url: `http://127.0.0.1:8000/ai/asin/getRandomAsin?country=us&t=${new Date().getTime()}}`,
                  content: {
                    method: 'get'
                  }
                }, function (res) {
                  if (res.code == 0) {
                    location.href = "https://www.amazon.com/dp/".concat(res.data);
                  }
                });

              case 5:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee13, this);
      }));
    } // 收集购物车商家

  }, {
    key: "asinCartData",
    value: function asinCartData() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee14() {
        var result, contentStatus, shopObj, shopDom, _i3, _shopDom2, row, start, shop, soldBy, sellerId, url;

        return _regeneratorRuntime().wrap(function _callee14$(_context15) {
          while (1) {
            switch (_context15.prev = _context15.next) {
              case 0:
                _context15.next = 2;
                return waitDom('.zying-tag-ship[data-action="show-all-offers-display"]', 60);

              case 2:
                result = _context15.sent;

                if (result) {
                  _context15.next = 6;
                  break;
                }

                this.getRandomAsin();
                return _context15.abrupt("return", false);

              case 6:
                _context15.next = 8;
                return (0, tools_1.sleep)(1000);

              case 8:
                chrome.storage.local.remove('failCount');
                this.cartPageFinish = true; // $(dom).find('[data-action="show-all-offers-display"]')[0].click()
                // $('#dynamic-aod-ingress-box [data-action="show-all-offers-display"]')[0].click()

                $('.zying-tag-ship[data-action="show-all-offers-display"]')[0].click();
                console.log('开始等待');

              case 12:
                if (!this.cartPageFinish) {
                  _context15.next = 18;
                  break;
                }

                if ($('[data-action="aod-close-on-esc-action"]:visible').length) {
                  this.cartPageFinish = false;
                }

                _context15.next = 16;
                return (0, tools_1.sleep)(2000);

              case 16:
                _context15.next = 12;
                break;

              case 18:
                console.log('请求完成');
                _context15.next = 21;
                return waitDom('#aod-container #aod-pinned-offer, #aod-offer-list > div', 20);

              case 21:
                contentStatus = _context15.sent;
                console.log('页面样式加载完成');

                if (contentStatus) {
                  _context15.next = 26;
                  break;
                }

                this.getRandomAsin();
                return _context15.abrupt("return", false);

              case 26:
                _context15.next = 28;
                return (0, tools_1.sleep)(3000);

              case 28:
                shopObj = [];
                shopDom = Array.from($('#aod-container #aod-pinned-offer, #aod-offer-list > div'));
                console.log('shopDom', shopDom);

                for (_i3 = 0, _shopDom2 = shopDom; _i3 < _shopDom2.length; _i3++) {
                  row = _shopDom2[_i3];
                  start = ($(row).find('#aod-offer-seller-rating').text() || '').match(/[\d]+(?= rating)/);
                  start = start ? parseInt(start[0]) : 0; // console.log('start', start)

                  if (start < 100) {
                    shop = $(row).find('#aod-offer-soldBy a[role="link"]').attr('href') || '';
                    soldBy = $(row).find('.a-fixed-left-grid:contains(Ships from)').find('span').eq(1).text();

                    if (!soldBy.includes('Amazon')) {
                      sellerId = shop.match(/(?<=seller=).*?(?=&)/);
                      sellerId = sellerId ? sellerId[0] : "";

                      if (sellerId) {
                        shopObj.push(sellerId);
                      }
                    }
                  }
                }

                console.log('shopObj', shopObj);

                if (!shopObj.length) {
                  _context15.next = 38;
                  break;
                }

                _context15.next = 36;
                return this.checkShopFit(shopObj);

              case 36:
                shopObj = _context15.sent;
                shopObj = shopObj.data;

              case 38:
                $('#aod-close i')[0].click();

                if (!(shopObj.length < 1)) {
                  _context15.next = 42;
                  break;
                }

                this.getRandomAsin();
                return _context15.abrupt("return", false);

              case 42:
                url = shopObj.shift();
                chrome.storage.local.set({
                  shopList: shopObj,
                  mode: "collectData"
                }, function () {
                  location.href = "https://www.amazon.com/s?me=".concat(url, "&marketplaceID=").concat(url);
                });

              case 44:
              case "end":
                return _context15.stop();
            }
          }
        }, _callee14, this);
      }));
    }
  }, {
    key: "zhiyinglogin",
    value: function zhiyinglogin() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee16() {
        var _this13 = this;

        return _regeneratorRuntime().wrap(function _callee16$(_context17) {
          while (1) {
            switch (_context17.prev = _context17.next) {
              case 0:
                $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').eq(0)[0].click();
                _context17.next = 3;
                return waitDom('.zying-login-transform input', 30);

              case 3:
                _context17.next = 5;
                return (0, tools_1.sleep)(2000);

              case 5:
                chrome.storage.local.get('zhiying', function (res) {
                  return __awaiter(_this13, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee15() {
                    var zhiying, input, lastValue, tracker, input2, lastValue2, tracker2;
                    return _regeneratorRuntime().wrap(function _callee15$(_context16) {
                      while (1) {
                        switch (_context16.prev = _context16.next) {
                          case 0:
                            zhiying = res === null || res === void 0 ? void 0 : res.zhiying.split('-');
                            input = $('.zying-login-transform input').eq(0)[0];
                            lastValue = input.value;
                            input.value = zhiying[0];
                            tracker = input._valueTracker;

                            if (tracker) {
                              tracker.setValue(lastValue);
                            }

                            ;
                            input.dispatchEvent(new Event('input', {
                              bubbles: true
                            }));
                            _context16.next = 10;
                            return (0, tools_1.sleep)(3000);

                          case 10:
                            input2 = $('.zying-login-transform input').eq(1)[0];
                            lastValue2 = input2.value;
                            input2.value = zhiying[1];
                            tracker2 = input2._valueTracker;

                            if (tracker2) {
                              tracker2.setValue(lastValue2);
                            }

                            ;
                            input2.dispatchEvent(new Event('input', {
                              bubbles: true
                            }));
                            _context16.next = 19;
                            return (0, tools_1.sleep)(2000);

                          case 19:
                            $('.zying-login-transform button[type="submit"]')[0].click();
                            _context16.next = 22;
                            return (0, tools_1.sleep)(5000);

                          case 22:
                            location.reload();

                          case 23:
                          case "end":
                            return _context16.stop();
                        }
                      }
                    }, _callee15);
                  }));
                });

              case 6:
              case "end":
                return _context17.stop();
            }
          }
        }, _callee16);
      }));
    }
  }]);

  return ContentScript;
}();

function waitDom(dom, time) {
  return new Promise(function (resolve) {
    var interval = setInterval(function () {
      if ($(dom).length) {
        clearInterval(interval);
        resolve(true);
      } else if (time < 1) {
        clearInterval(interval);
        resolve(false);
      }

      time -= 1;
    }, 500);
  });
} // window.onload = function () {
//   console.log('load')
//   if (location.href.includes('amazon.com')) {
//     let cs = new ContentScript()


setTimeout(function () {
  if (location.href.includes('amazon.com')) {
    var cs = new ContentScript();
    cs.init();
  }
}, 5000); //   }
// }

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__(12);
/******/ 	
/******/ })()
;