// 监听前端页面发来的消息
window.addEventListener('message', (event) => {
    // 验证消息来源和类型（安全措施）
    if (event.source !== window || event.data.type !== 'EXTENSION_GET_TASK') {
        return;
    }

    // 收到前端请求后，转发给扩展背景页
    if (event.data.action === 'getTask') {
        chrome.runtime.sendMessage(
            { type: 'getTask' }, // 与背景页约定的消息类型
            (response) => {
                // 将背景页的响应回传给前端页面
                window.postMessage(
                    {
                        type: 'EXTENSION_TASK_RESPONSE',
                        response: response || { success: false, error: '无响应' }
                    },
                    '*' // 生产环境指定前端域名
                );
            }
        );
    }else if (event.data.action === 'reset') {
        chrome.runtime.sendMessage(
            { type: 'reset' },
            (response) => {
                // 先获取 crx-token 的值
                chrome.storage.local.get('crx-token', (storageResult) => {
                    const token = storageResult['crx-token'];
                    console.log(token);
                    // 根据 token 是否存在构造响应消息
                    window.postMessage(
                        {
                            type: 'EXTENSION_TASK_RESPONSE',
                            response: token
                                ? { success: true, message: token }  // 使用获取到的 token
                                : { success: false, error: '未找到 crx-token' }  // 未找到时的提示
                        },
                        '*' // 生产环境建议指定具体域名
                    );
                });
            }
        );
    }

});