/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 2:
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.waitDom = exports.sleep = exports.setStorage = exports.getStorage = exports.getCurrentDate = exports.addToClipBoard = exports.showMsg = void 0; // 添加消息

var style = document.createElement('style');
style.innerText = "\n@media (min-width: 100px){\n  .plugin-pop-cls{\n    position: fixed;\n    width:100vw;\n    top:0vh;\n    height: 1px;\n    text-align: center;\n    z-index:100000;\n    left: 0;\n  }\n}\n\n@media (min-width: 900px){\n  .plugin-pop-cls{\n    position: fixed;\n    width:30vw;\n    top:15vh;\n    height: 1px;\n    left:34vw;\n    text-align: center;\n    z-index:100000\n  }\n}\n\n\n.plugin-alert{\n  width:100%;\n  font-size:14px;\n  padding:10px;\n  text-align: center;\n  margin-bottom: 20px;\n  border-width: 1px;\n  border-style: solid;\n  border-radius: 4px;\n}\n.plugin-success{\n  color:rgb(60, 118, 61);\n  background-color: rgb(223, 240, 216);\n  border-color: rgb(214, 233, 198);\n}\n.plugin-warning{\n  color: #a94442;\n  background-color: #f2dede;\n  border-color: #ebccd1;\n}\ninput,button,select,textarea{outline:none}";

var _interval = setInterval(function () {
  if (document.head) {
    clearInterval(_interval);
    document.head.appendChild(style);
  }
}, 2000);

function showMsg(title) {
  var status = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "success";
  var during = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 2000;

  if ($('.plugin-pop-cls').length == 0) {
    $('body').append('<div class="plugin-pop-cls"></div>');
  }

  var cls = "cls" + new Date().getTime();
  var statusClass = '';

  if (status == 'success') {
    statusClass = 'plugin-success';
  } else {
    statusClass = 'plugin-warning';
  }

  $('.plugin-pop-cls').append("<div class=\"plugin-alert ".concat(cls, " ").concat(statusClass, "\">").concat(title, "</div>"));
  setTimeout(function () {
    $(".".concat(cls)).remove();
  }, during);
}

exports.showMsg = showMsg; // 复制到剪切板

function addToClipBoard(str) {
  var transfer = document.createElement('input');
  $('body').append(transfer);
  transfer.value = str;
  transfer.focus();
  transfer.select();

  if (document.execCommand('copy')) {
    document.execCommand('copy');
  }

  transfer.blur();
  $('body input').remove();
}

exports.addToClipBoard = addToClipBoard; // 获取当前日期

function getCurrentDate() {
  var current_date = new Date();
  var years = current_date.getFullYear();
  var month = current_date.getMonth() + 1;
  month = month < 10 ? '0' + month : month;
  var day = current_date.getDate();
  day = day < 10 ? '0' + day : day;
  var hours = current_date.getHours();
  var minute = current_date.getMinutes();
  return [years, month, day, hours, minute];
}

exports.getCurrentDate = getCurrentDate;

function getClipInfo() {
  var helperdiv = document.createElement("div");
  document.body.appendChild(helperdiv);
  helperdiv.contentEditable = true; // focus the helper div's content

  var range = document.createRange();
  range.selectNode(helperdiv);
  var selection = window.getSelection();
  selection && selection.removeAllRanges();
  selection && selection.addRange(range);
  helperdiv.focus(); // trigger the paste action

  document.execCommand("Paste"); // read the clipboard contents from the helperdiv

  var clipboardContents = helperdiv.innerHTML;
  console.log("\u5F53\u524D\u526A\u5207\u677F\u5185\u5BB9\u4E3A:".concat(clipboardContents));
  document.body.removeChild(helperdiv);
  return clipboardContents;
}

function getStorage(_arr) {
  return new Promise(function (resolve) {
    chrome.storage.local.get(_arr, function (res) {
      resolve(res);
    });
  });
}

exports.getStorage = getStorage;

function setStorage(obj) {
  return new Promise(function (resolve) {
    chrome.storage.local.set(obj, function () {
      resolve('');
    });
  });
}

exports.setStorage = setStorage;

function sleep(ts) {
  return new Promise(function (resolve) {
    setTimeout(function () {
      resolve('');
    }, ts);
  });
}

exports.sleep = sleep;

function waitDom(dom) {
  return new Promise(function (resolve) {
    var interval = setInterval(function () {
      if ($(dom).length) {
        clearInterval(interval);
        resolve('');
      }
    }, 100);
  });
}

exports.waitDom = waitDom;

/***/ }),

/***/ 15:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var tools_1 = __webpack_require__(2);

var ContentScript = /*#__PURE__*/function () {
  function ContentScript() {
    _classCallCheck(this, ContentScript);

    // 新增：任务状态管理
    this.taskStatus = 'running'; // 购物车页面

    this.cartPageFinish = false;
    this.cartPageWaitLoadTime = 20; // 监听页面加载

    this.listenAjaxPage = false; // interval

    this.requestInterval = '5-8';
    this.listenPaginationTimeout = '';
    this.minPriceObj = {
      com: 7,
      jp: 800,
      ca: 10
    };
    this.minPriceVal = 0;
    this.category = [];
    this.blockCategory = [];
    this.blockTitle = [];
    this.task_id = ''; // 新增：记录智赢加载失败次数

    this.loadFailCount = 0; // 新增：保存当前进度

    this.currentProgress = {
      totalAsin: 0,
      currentPage: 1
    }; // 新增：停滞监控相关变量

    this.lastActivityTime = Date.now();
    this.watchdogTimer = null;
    this.watchdogTimeout = 30000; // 30秒无活动判定为停滞
    // // 初始化停滞监控
    // this.startWatchdog();
  } // 新增：标记活动发生


  _createClass(ContentScript, [{
    key: "markActivity",
    value: function markActivity() {
      this.lastActivityTime = Date.now();
    } // 新增：启动看门狗定时器监控停滞

  }, {
    key: "startWatchdog",
    value: function startWatchdog() {
      var _this = this;

      console.log("shopAsin startWatchdog启动"); // 清除之前的定时器（如果有）

      if (this.watchdogTimer) {
        clearInterval(this.watchdogTimer);
      }

      this.watchdogTimer = setInterval(function () {
        var now = Date.now();
        var elapsed = now - _this.lastActivityTime; // 只在任务运行中且停滞超过阈值时触发

        if (_this.taskStatus === 'running' && elapsed > _this.watchdogTimeout) {
          console.log("\u68C0\u6D4B\u5230\u4EFB\u52A1\u505C\u6EDE\uFF1A".concat(Math.round(elapsed / 1000), "\u79D2\u672A\u54CD\u5E94\uFF0C\u5F00\u59CB\u81EA\u52A8\u6062\u590D..."));

          _this.handleTaskStagnation();
        }
      }, 5000); // 每5秒检查一次
    } // 新增：处理任务停滞情况

  }, {
    key: "handleTaskStagnation",
    value: function handleTaskStagnation() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // 停止当前任务的看门狗定时器
                if (this.watchdogTimer) {
                  clearInterval(this.watchdogTimer);
                  this.watchdogTimer = null;
                } // 保存当前进度


                _context.prev = 1;
                _context.next = 4;
                return chrome.storage.local.set({
                  taskProgress: this.currentProgress
                });

              case 4:
                console.log('任务停滞，已保存当前进度');
                _context.next = 10;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](1);
                console.error('保存进度时出错:', _context.t0);

              case 10:
                // 刷新页面恢复任务
                console.log('刷新页面以恢复任务...');
                location.reload();

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[1, 7]]);
      }));
    } // 新增：停止看门狗定时器

  }, {
    key: "stopWatchdog",
    value: function stopWatchdog() {
      console.log("shopAsin stopWatchdog关闭");

      if (this.watchdogTimer) {
        clearInterval(this.watchdogTimer);
        this.watchdogTimer = null;
      }
    }
  }, {
    key: "init",
    value: function init() {
      var _this2 = this;

      // 初始化时从localStorage获取失败次数
      var failCount = localStorage.getItem('failCount');
      this.loadFailCount = failCount ? parseInt(failCount, 10) : 0;

      if (location.href.includes('https://www.amazon.com/s?')) {
        chrome.storage.local.get(['taskConfig'], function (res) {
          return __awaiter(_this2, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
            var _a, _b;

            return _regeneratorRuntime().wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    if (!(!(res === null || res === void 0 ? void 0 : res.taskConfig) || ((_a = res.taskConfig) === null || _a === void 0 ? void 0 : _a.type) !== 'shopAsin' || ((_b = res.taskConfig) === null || _b === void 0 ? void 0 : _b.status) !== 'run')) {
                      _context2.next = 2;
                      break;
                    }

                    return _context2.abrupt("return", false);

                  case 2:
                    this.task_id = res.taskConfig.info.id;
                    console.log('开始执行');

                    this._startCollect();

                    if (res.taskConfig.type == 'shopAsin') {
                      // 初始化停滞监控
                      this.startWatchdog();
                      this.addControlUI(); // 添加控制UI
                    }

                  case 6:
                  case "end":
                    return _context2.stop();
                }
              }
            }, _callee2, this);
          }));
        }); // 监听消息（包含暂停/停止指令）

        this.listenBgMessage();
      }

      if (location.href.includes('https://www.amazon.com/sp')) {
        chrome.storage.local.get(['taskConfig'], function (res) {
          return __awaiter(_this2, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
            var _this3 = this;

            var _c, _d;

            return _regeneratorRuntime().wrap(function _callee3$(_context3) {
              while (1) {
                switch (_context3.prev = _context3.next) {
                  case 0:
                    if (!(!(res === null || res === void 0 ? void 0 : res.taskConfig) || ((_c = res.taskConfig) === null || _c === void 0 ? void 0 : _c.type) !== 'shopCartPrice' || ((_d = res.taskConfig) === null || _d === void 0 ? void 0 : _d.status) !== 'run')) {
                      _context3.next = 2;
                      break;
                    }

                    return _context3.abrupt("return", false);

                  case 2:
                    setInterval(function () {
                      // 检查任务状态，只在运行中执行
                      if (_this3.taskStatus === 'running' && location.href.includes('https://www.amazon.com/sp') && $('#seller-info-storefront-link').length) {
                        $('#seller-info-storefront-link a').eq(0)[0].click();
                      }
                    }, 8 * 1000);

                  case 3:
                  case "end":
                    return _context3.stop();
                }
              }
            }, _callee3);
          }));
        });
      }
    } // 新增：添加控制按钮UI

  }, {
    key: "addControlUI",
    value: function addControlUI() {
      var _this4 = this;

      var _a, _b, _c; // 避免重复添加


      if (document.getElementById('task-control-panel')) return;
      var panel = document.createElement('div');
      panel.id = 'task-control-panel';
      panel.style.position = 'fixed';
      panel.style.top = '20px';
      panel.style.right = '20px';
      panel.style.zIndex = '999999';
      panel.style.backgroundColor = 'white';
      panel.style.border = '1px solid #ddd';
      panel.style.borderRadius = '8px';
      panel.style.padding = '15px';
      panel.style.boxShadow = '0 2px 10px rgba(0,0,0,0.1)';
      panel.innerHTML = "\n      <div style=\"margin-bottom: 10px; font-weight: bold;\">\u4EFB\u52A1\u63A7\u5236</div>\n      <div style=\"display: flex; gap: 10px;\">\n        <button id=\"pause-btn\" style=\"padding: 5px 10px; background: #4285f4; color: white; border: none; border-radius: 4px; cursor: pointer;\">\u6682\u505C</button>\n        <button id=\"resume-btn\" style=\"padding: 5px 10px; background: #34a853; color: white; border: none; border-radius: 4px; cursor: pointer; display: none;\">\u7EE7\u7EED</button>\n        <button id=\"stop-btn\" style=\"padding: 5px 10px; background: #ea4335; color: white; border: none; border-radius: 4px; cursor: pointer;\">\u505C\u6B62</button>\n      </div>\n      <div id=\"status-indicator\" style=\"margin-top: 10px; font-size: 12px; color: #666;\">\u72B6\u6001\uFF1A\u8FD0\u884C\u4E2D</div>\n    ";
      document.body.appendChild(panel); // 绑定事件

      (_a = document.getElementById('pause-btn')) === null || _a === void 0 ? void 0 : _a.addEventListener('click', function () {
        return _this4.pauseTask();
      });
      (_b = document.getElementById('resume-btn')) === null || _b === void 0 ? void 0 : _b.addEventListener('click', function () {
        return _this4.resumeTask();
      });
      (_c = document.getElementById('stop-btn')) === null || _c === void 0 ? void 0 : _c.addEventListener('click', function () {
        return _this4.stopTask();
      });
    } // 新增：暂停任务

  }, {
    key: "pauseTask",
    value: function pauseTask() {
      var _this5 = this;

      if (this.taskStatus !== 'running') return;
      this.taskStatus = 'paused';
      console.log('任务已暂停');
      this.updateControlUI(); // 停止看门狗定时器

      this.stopWatchdog(); // 保存当前进度

      chrome.storage.local.get('totalAsin', function (res) {
        _this5.currentProgress.totalAsin = res.totalAsin || 0;
        chrome.storage.local.set({
          taskProgress: _this5.currentProgress
        });
      }); // 发送暂停状态到背景页

      chrome.runtime.sendMessage({
        type: "taskStatus",
        status: "paused",
        task_id: this.task_id
      });
    } // 新增：恢复任务

  }, {
    key: "resumeTask",
    value: function resumeTask() {
      if (this.taskStatus !== 'paused') return;
      this.taskStatus = 'running';
      console.log('任务已恢复');
      this.updateControlUI(); // 重新启动看门狗定时器

      this.startWatchdog(); // 发送恢复状态到背景页

      chrome.runtime.sendMessage({
        type: "taskStatus",
        status: "running",
        task_id: this.task_id
      }); // 继续执行任务

      this._startCollect();
    } // 新增：停止任务

  }, {
    key: "stopTask",
    value: function stopTask() {
      var _a;

      this.taskStatus = 'stopped';
      console.log('任务已停止');
      this.updateControlUI(); // 停止看门狗定时器

      this.stopWatchdog(); // 清理存储

      chrome.storage.local.remove('taskConfig');
      chrome.storage.local.remove('totalAsin');
      chrome.storage.local.remove('taskProgress'); // 发送停止状态到背景页

      chrome.runtime.sendMessage({
        type: "taskStatus",
        status: "stopped",
        task_id: this.task_id
      }); // 通知服务器任务已停止

      chrome.runtime.sendMessage({
        type: "http",
        url: "".concat("https://www.genmaijl.com", "/ai/task/finish"),
        content: {
          method: 'put',
          body: JSON.stringify({
            id: this.task_id
          })
        }
      }, function () {}); // 移除控制UI

      (_a = document.getElementById('task-control-panel')) === null || _a === void 0 ? void 0 : _a.remove(); // 显示停止提示

      (0, tools_1.showMsg)('任务已停止' + this.task_id);
    } // 新增：更新控制UI状态

  }, {
    key: "updateControlUI",
    value: function updateControlUI() {
      var statusEl = document.getElementById('status-indicator');
      var pauseBtn = document.getElementById('pause-btn');
      var resumeBtn = document.getElementById('resume-btn');
      if (!statusEl || !pauseBtn || !resumeBtn) return;

      switch (this.taskStatus) {
        case 'running':
          statusEl.textContent = '状态：运行中';
          pauseBtn.style.display = 'block';
          resumeBtn.style.display = 'none';
          break;

        case 'paused':
          statusEl.textContent = '状态：已暂停';
          pauseBtn.style.display = 'none';
          resumeBtn.style.display = 'block';
          break;

        case 'stopped':
          statusEl.textContent = '状态：已停止';
          pauseBtn.style.display = 'none';
          resumeBtn.style.display = 'none';
          break;
      }
    } // 开始收集数据

  }, {
    key: "_startCollect",
    value: function _startCollect() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
        var _this6 = this;

        var _timeout, loadSuccess;

        return _regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                if (!(this.taskStatus !== 'running')) {
                  _context5.next = 2;
                  break;
                }

                return _context5.abrupt("return");

              case 2:
                // 标记活动
                this.markActivity(); // 等待30s 如果页面没有出现商品 切换店铺

                _timeout = setTimeout(function () {
                  return __awaiter(_this6, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
                    return _regeneratorRuntime().wrap(function _callee4$(_context4) {
                      while (1) {
                        switch (_context4.prev = _context4.next) {
                          case 0:
                            console.log('加载超时，记录失败次数');
                            this.markActivity();
                            this.handleLoadFailure();

                          case 3:
                          case "end":
                            return _context4.stop();
                        }
                      }
                    }, _callee4, this);
                  }));
                }, 100 * 1000); // 等待加载完成

                _context5.next = 6;
                return this.sellerLoadFinish();

              case 6:
                loadSuccess = _context5.sent;
                clearTimeout(_timeout);

                if (loadSuccess) {
                  // 加载成功，重置失败计数
                  this.markActivity();
                  this.loadFailCount = 0;
                  localStorage.removeItem('failCount');
                  this.circulationRequest();
                }

              case 9:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));
    }
  }, {
    key: "circulationRequest",
    value: function circulationRequest() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee6() {
        var _this7 = this;

        var domList, totalAsin, _loop, _i, _domList, _ret;

        return _regeneratorRuntime().wrap(function _callee6$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                if (!(this.taskStatus !== 'running')) {
                  _context7.next = 2;
                  break;
                }

                return _context7.abrupt("return");

              case 2:
                // 标记活动
                this.markActivity();
                domList = Array.from($('[role="listitem"].s-result-item'));

                if (!(!$('[aria-label="exclamation-circle"]:visible, [aria-label="check-circle"]:visible').length && $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').length)) {
                  _context7.next = 8;
                  break;
                }

                this.markActivity();
                this.zhiyinglogin();
                return _context7.abrupt("return", false);

              case 8:
                _context7.next = 10;
                return chrome.storage.local.get('totalAsin');

              case 10:
                totalAsin = _context7.sent;
                totalAsin = (totalAsin === null || totalAsin === void 0 ? void 0 : totalAsin.totalAsin) || 0; // 更新当前进度

                this.currentProgress.totalAsin = totalAsin;
                this.markActivity();
                chrome.storage.local.set({
                  taskProgress: this.currentProgress
                });
                _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
                  var row, that, asin, priceText, priceMatch, price, sellNumberText, sellNumberMatch, sell_number, sell_type, sort, market_idMatch, market_id, monthSellText, monthSellMatch, month_sell, feedbackScoreText, feedbackScoreMatch, feedback_score, data;
                  return _regeneratorRuntime().wrap(function _loop$(_context6) {
                    while (1) {
                      switch (_context6.prev = _context6.next) {
                        case 0:
                          row = _domList[_i];

                          if (!(_this7.taskStatus !== 'running')) {
                            _context6.next = 3;
                            break;
                          }

                          return _context6.abrupt("return", {
                            v: void 0
                          });

                        case 3:
                          // 标记活动
                          _this7.markActivity();

                          totalAsin += 1;

                          if (!(totalAsin > 500)) {
                            _context6.next = 10;
                            break;
                          }

                          _this7.markActivity();

                          _context6.next = 9;
                          return chrome.storage.local.set({
                            totalAsin: totalAsin
                          });

                        case 9:
                          return _context6.abrupt("return", "break");

                        case 10:
                          that = $(row);
                          asin = that.attr('data-asin');
                          priceText = that.find('.a-offscreen').eq(0).text() || '';
                          priceMatch = priceText.match(/[\d,.]+/);
                          price = priceMatch ? priceMatch[0] : "0";
                          sellNumberText = that.find('a[data-action="show-all-offers-display"]').eq(0).text() || '0';
                          sellNumberMatch = sellNumberText.match(/[\d]+/);
                          sell_number = sellNumberMatch ? sellNumberMatch[0] : '0';
                          sell_type = that.find('.zying-tag-ship._1wyo2vd2g').text();
                          sort = [];
                          that.find('.ranktag').each(function () {
                            sort.push($(this).text().trim() + $(this).next().text().trim());
                          });
                          market_idMatch = document.documentElement.innerHTML.match(/(?<=ObfuscatedMarketplaceId': ')[\s\S]*?(?=')/gi);
                          market_id = market_idMatch ? market_idMatch[0] : "";
                          monthSellText = that.find('span._1wyo2vd18._1wyo2vdw._1wyo2vd1 > span').text() || '';
                          monthSellMatch = monthSellText.match(/[\d]+/);
                          month_sell = monthSellMatch ? monthSellMatch[0] : '0';
                          feedbackScoreText = that.find('[data-cy="reviews-ratings-slot"]').text();
                          feedbackScoreMatch = feedbackScoreText.match(/[\d.]+/);
                          feedback_score = feedbackScoreMatch ? feedbackScoreMatch[0] : 0;
                          data = {
                            asin: asin,
                            h10_seller: '',
                            cart_price: parseFloat(price),
                            title: that.find('h2>span').text().trim(),
                            mainImg: that.find('img.s-image').attr('src'),
                            brand: that.find('._1wyo2vd18._1wyo2vdw._1wyo2vd6').text().trim() || '',
                            seller_number: sell_number,
                            seller_type: sell_type,
                            sort: JSON.stringify(sort),
                            country: _this7.getCountry(),
                            market_id: market_id,
                            feedback_score: feedback_score,
                            comment_number: that.find('[data-component-type="s-client-side-analytics"]').text(),
                            brand_status: that.find('._1wyo2vd0._1wyo2vd1j._1wyo2vdc').length ? 'normal' : "已注册",
                            cart_seller_name: that.find('._1wyo2vd18._1wyo2vd2h._1wyo2vd6').text(),
                            month_sell: month_sell,
                            online_time: that.find('div._1wyo2vd18._1wyo2vdw._1wyo2vd1 > span._1wyo2vd18._1wyo2vdw._1wyo2vd1').text(),
                            task_id: _this7.task_id
                          };
                          chrome.runtime.sendMessage({
                            type: "http",
                            url: "".concat("https://www.genmaijl.com", "/ai/task/uploadData"),
                            content: {
                              method: 'post',
                              body: JSON.stringify(data)
                            }
                          }, function () {}); // 标记活动

                          _context6.next = 33;
                          return (0, tools_1.sleep)(2000);

                        case 33:
                          _this7.markActivity();

                        case 34:
                        case "end":
                          return _context6.stop();
                      }
                    }
                  }, _loop);
                });
                _i = 0, _domList = domList;

              case 17:
                if (!(_i < _domList.length)) {
                  _context7.next = 27;
                  break;
                }

                return _context7.delegateYield(_loop(), "t0", 19);

              case 19:
                _ret = _context7.t0;

                if (!(_ret === "break")) {
                  _context7.next = 22;
                  break;
                }

                return _context7.abrupt("break", 27);

              case 22:
                if (!(_typeof(_ret) === "object")) {
                  _context7.next = 24;
                  break;
                }

                return _context7.abrupt("return", _ret.v);

              case 24:
                _i++;
                _context7.next = 17;
                break;

              case 27:
                _context7.next = 29;
                return (0, tools_1.sleep)(2000);

              case 29:
                this.markActivity();
                this.markActivity();
                _context7.next = 33;
                return chrome.storage.local.set({
                  totalAsin: totalAsin
                });

              case 33:
                console.log('此页面采集结束');
                (0, tools_1.showMsg)('此页面采集结束'); // 检查任务状态，如果是运行中则继续下一页

                if (this.taskStatus === 'running') {
                  this.currentProgress.currentPage++;
                  this.runNext();
                }

              case 36:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee6, this);
      }));
    }
  }, {
    key: "listenBgMessage",
    value: function listenBgMessage() {
      var _this8 = this;

      chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
        switch (request.type) {
          case 'requestFinish':
            if (_this8.listenAjaxPage && _this8.taskStatus === 'running') {
              setTimeout(function () {
                _this8._startCollect();
              }, 2000);
            } else if (_this8.cartPageFinish) {
              _this8.cartPageFinish = false;
            }

            break;
          // 新增：处理来自背景页的暂停/停止指令

          case 'taskControl':
            if (request.action === 'pause') {
              _this8.pauseTask();
            } else if (request.action === 'resume') {
              _this8.resumeTask();
            } else if (request.action === 'stop') {
              _this8.stopTask();
            }

            break;
        }
      });
    }
  }, {
    key: "sellerLoadFinish",
    value: function sellerLoadFinish() {
      var _this9 = this;

      return new Promise(function (resolve) {
        return __awaiter(_this9, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee7() {
          var _this10 = this;

          var maxCount, sellerInterval, timeout;
          return _regeneratorRuntime().wrap(function _callee7$(_context8) {
            while (1) {
              switch (_context8.prev = _context8.next) {
                case 0:
                  maxCount = 0;
                  sellerInterval = null;
                  timeout = null;
                  sellerInterval = setInterval(function () {
                    // 状态检查
                    if (_this10.taskStatus !== 'running') {
                      clearInterval(sellerInterval);
                      clearTimeout(timeout);
                      resolve(false);
                      return;
                    } // 标记活动


                    _this10.markActivity();

                    maxCount += 1;

                    if ($('[aria-label="exclamation-circle"], [aria-label="check-circle"]').length / $('[role="listitem"].s-result-item').length > 0.7) {
                      localStorage.removeItem('failCount');
                      console.log('智赢加载完成');
                      clearInterval(sellerInterval);
                      clearTimeout(timeout);
                      setTimeout(function () {
                        return resolve(true);
                      }, 5000);
                    }
                  }, 4000);
                  timeout = setTimeout(function () {
                    clearInterval(sellerInterval);

                    if (!$('[aria-label="exclamation-circle"]:visible, [aria-label="check-circle"]:visible').length && $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').length) {
                      _this10.zhiyinglogin();

                      resolve(false);
                    } else {
                      resolve(false);
                    }
                  }, 10 * 1000);

                case 5:
                case "end":
                  return _context8.stop();
              }
            }
          }, _callee7);
        }));
      });
    } // 处理加载失败的逻辑

  }, {
    key: "handleLoadFailure",
    value: function handleLoadFailure() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
        return _regeneratorRuntime().wrap(function _callee8$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                if (!(this.taskStatus !== 'running')) {
                  _context9.next = 2;
                  break;
                }

                return _context9.abrupt("return");

              case 2:
                this.loadFailCount++;
                localStorage.setItem('failCount', this.loadFailCount.toString());
                console.log("\u667A\u8D62\u52A0\u8F7D\u5931\u8D25\uFF0C\u6B21\u6570: ".concat(this.loadFailCount)); // 失败3次，自动换下一页

                if (!(this.loadFailCount >= 3)) {
                  _context9.next = 13;
                  break;
                }

                console.log('智赢加载失败3次，自动换下一页'); // 重置失败计数

                this.loadFailCount = 0;
                localStorage.removeItem('failCount'); // 执行下一页操作

                _context9.next = 11;
                return this.runNext();

              case 11:
                _context9.next = 15;
                break;

              case 13:
                // 未达到3次，刷新页面重试
                console.log("\u672A\u8FBE\u52303\u6B21\u5931\u8D25\uFF0C\u5237\u65B0\u9875\u9762\u91CD\u8BD5\uFF08\u5F53\u524D".concat(this.loadFailCount, "\u6B21\uFF09"));
                location.reload();

              case 15:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee8, this);
      }));
    }
  }, {
    key: "runNext",
    value: function runNext() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee9() {
        var _this11 = this;

        var totalAsin, next;
        return _regeneratorRuntime().wrap(function _callee9$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                if (!(this.taskStatus !== 'running')) {
                  _context10.next = 2;
                  break;
                }

                return _context10.abrupt("return");

              case 2:
                // 标记活动
                this.markActivity();
                _context10.next = 5;
                return chrome.storage.local.get('totalAsin');

              case 5:
                totalAsin = _context10.sent;
                totalAsin = (totalAsin === null || totalAsin === void 0 ? void 0 : totalAsin.totalAsin) || 0;
                next = $('span.s-pagination-selected').parents('ul').find('a:contains(Next)');

                if (next.length && totalAsin < 500) {
                  console.log('nextPage');
                  this.listenAjaxPage = true;
                  this.markActivity();
                  next[0].click();
                } else {
                  // 获取总采集数量并显示弹窗
                  chrome.storage.local.get('totalAsin', function (res) {
                    var totalCount = res.totalAsin || 0;

                    _this11.showCompletionPopup(totalCount);
                  }); // 任务完成，调用background.ts中的onTaskCompleted函数执行下一个任务

                  chrome.runtime.sendMessage({
                    type: "taskCompleted",
                    taskId: this.task_id
                  }); // 更新任务状态为已完成并停止看门狗定时器

                  this.taskStatus = 'stopped';
                  this.stopWatchdog(); // 任务完成时停止看门狗

                  this.updateControlUI();
                }

              case 9:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee9, this);
      }));
    } // 显示任务完成弹窗

  }, {
    key: "showCompletionPopup",
    value: function showCompletionPopup(totalCount) {
      // 创建弹窗元素
      var popup = document.createElement('div'); // 设置弹窗样式

      popup.style.position = 'fixed';
      popup.style.bottom = '20px';
      popup.style.right = '20px';
      popup.style.width = '300px';
      popup.style.backgroundColor = '#ffffff';
      popup.style.borderRadius = '8px';
      popup.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.15)';
      popup.style.padding = '16px';
      popup.style.zIndex = '99999';
      popup.style.fontFamily = 'Arial, sans-serif';
      popup.style.border = '1px solid #e0e0e0';
      popup.style.transition = 'all 0.3s ease'; // 弹窗内容

      popup.innerHTML = "\n      <div style=\"display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;\">\n        <h3 style=\"margin: 0; color: #333; font-size: 16px;\">\u4EFB\u52A1\u5DF2\u5B8C\u6210</h3>\n        <button id=\"closePopup\" style=\"background: none; border: none; cursor: pointer; color: #999; font-size: 18px;\">&times;</button>\n      </div>\n      <p style=\"margin: 0 0 15px 0; color: #666; font-size: 14px;\">\u672C\u6B21\u5171\u91C7\u96C6\u5230 <strong style=\"color: #2196F3;\">".concat(totalCount, "</strong> \u6761\u6570\u636E</p>\n      <div style=\"text-align: right;\">\n        <button id=\"confirmBtn\" style=\"background-color: #2196F3; color: white; border: none; padding: 6px 12px; border-radius: 4px; cursor: pointer; font-size: 14px;\">\u786E\u5B9A</button>\n      </div>\n    "); // 添加到页面

      document.body.appendChild(popup); // 关闭按钮事件

      var closeBtn = popup.querySelector('#closePopup');
      closeBtn.addEventListener('click', function () {
        popup.remove();
      }); // 确定按钮事件

      var confirmBtn = popup.querySelector('#confirmBtn');
      confirmBtn.addEventListener('click', function () {
        popup.remove();
      }); // 10秒后自动关闭

      setTimeout(function () {
        if (document.body.contains(popup)) {
          popup.style.opacity = '0';
          setTimeout(function () {
            return popup.remove();
          }, 300);
        }
      }, 10000);
    }
  }, {
    key: "getCountry",
    value: function getCountry() {
      var platform = '';
      var host = window.location.host;
      var topLevelDomain = host.split('.').pop();

      if (topLevelDomain === 'ca') {
        platform = "加拿大";
      } else if (topLevelDomain === 'com') {
        platform = '美国';
      } else if (topLevelDomain === 'jp') {
        platform = '日本';
      } else if (topLevelDomain === 'de') {
        platform = '德国';
      } else if (topLevelDomain === 'fr') {
        platform = '法国';
      } else if (topLevelDomain === 'uk') {
        platform = '英国';
      } else if (topLevelDomain === 'mx') {
        platform = '墨西哥';
      } else if (topLevelDomain === 'au') {
        platform = '澳大利亚';
      }

      return platform;
    }
  }, {
    key: "zhiyinglogin",
    value: function zhiyinglogin() {
      return __awaiter(this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee11() {
        var _this12 = this;

        return _regeneratorRuntime().wrap(function _callee11$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                if (!(this.taskStatus !== 'running')) {
                  _context12.next = 2;
                  break;
                }

                return _context12.abrupt("return");

              case 2:
                // 标记活动
                this.markActivity();
                $('._1wyo2vd6._1wyo2vdv._1wyo2vd1j._1wyo2vd1h').eq(0)[0].click();
                _context12.next = 6;
                return waitDom('.zying-login-transform input', 30);

              case 6:
                this.markActivity();
                _context12.next = 9;
                return (0, tools_1.sleep)(2000);

              case 9:
                this.markActivity();
                chrome.storage.local.get('zhiying', function (res) {
                  return __awaiter(_this12, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee10() {
                    var zhiying, input, lastValue, tracker, input2, lastValue2, tracker2;
                    return _regeneratorRuntime().wrap(function _callee10$(_context11) {
                      while (1) {
                        switch (_context11.prev = _context11.next) {
                          case 0:
                            zhiying = res === null || res === void 0 ? void 0 : res.zhiying.split('-');

                            if (zhiying) {
                              _context11.next = 3;
                              break;
                            }

                            return _context11.abrupt("return");

                          case 3:
                            input = $('.zying-login-transform input').eq(0)[0];
                            lastValue = input.value;
                            input.value = zhiying[0];
                            tracker = input._valueTracker;

                            if (tracker) {
                              tracker.setValue(lastValue);
                            }

                            input.dispatchEvent(new Event('input', {
                              bubbles: true
                            }));
                            _context11.next = 11;
                            return (0, tools_1.sleep)(3000);

                          case 11:
                            this.markActivity();
                            input2 = $('.zying-login-transform input').eq(1)[0];
                            lastValue2 = input2.value;
                            input2.value = zhiying[1];
                            tracker2 = input2._valueTracker;

                            if (tracker2) {
                              tracker2.setValue(lastValue2);
                            }

                            input2.dispatchEvent(new Event('input', {
                              bubbles: true
                            }));
                            _context11.next = 20;
                            return (0, tools_1.sleep)(2000);

                          case 20:
                            this.markActivity();
                            $('.zying-login-transform button[type="submit"]')[0].click();
                            _context11.next = 24;
                            return (0, tools_1.sleep)(5000);

                          case 24:
                            this.markActivity();
                            location.reload();

                          case 26:
                          case "end":
                            return _context11.stop();
                        }
                      }
                    }, _callee10, this);
                  }));
                });

              case 11:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee11, this);
      }));
    }
  }]);

  return ContentScript;
}();

function waitDom(dom, time) {
  return new Promise(function (resolve) {
    var interval = setInterval(function () {
      if ($(dom).length) {
        clearInterval(interval);
        resolve(true);
      } else if (time < 1) {
        clearInterval(interval);
        resolve(false);
      }

      time -= 1;
    }, 500);
  });
}

setTimeout(function () {
  if (location.href.includes('amazon.com')) {
    var cs = new ContentScript();
    cs.init();
  }
}, 2000);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__(15);
/******/ 	
/******/ })()
;